﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;
using System.IO;
using System.Xml.Serialization;
using System.Xml;

namespace Fiskalizacija.DOS.SysTray
{
    public class Configuration
    {
        public string OIB { get; set; }
        public string USustavuPDV { get; set; }
        public string OznakaSlijednosti { get; set; }
        public string OznakaPoslProstora { get; set; }
        public string OznakaNaplatnogUredjaja { get; set; }
        public bool NepostojecaAdresa { get; set; }
        public string Ulica { get; set; }
        public string KucniBroj { get; set; }
        public string DodatakKucnomBroju { get; set; }
        public string Posta { get; set; }
        public string Naselje { get; set; }
        public string Opcina { get; set; }
        public string OstaliTipPP { get; set; }
        //public string RadnoVrijeme { get; set; }
        //public string DatumPocetka { get; set; }
        //public string OznakaZatvaranja { get; set; }
        public string OIBprogramera { get; set; }

        public string CertificateSubject { get; set; }
        public string CertificateFile { get; set; }
        public string CertificatePass { get; set; }
        public string RequestFile { get; set; }
        public string ResponseFile { get; set; }
        public string Url { get; set; }
        public string UrlTocnoVrijeme { get; set; }
        public string LogFolder { get; set; }
        public string Password { get; set; }
        public decimal Timeout { get; set; }
        public decimal Polling { get; set; }
        public bool Offline { get; set; }
        public bool? KontrolaRB { get; set; }
        public bool? KontrolaVremena { get; set; }
        public bool? BrisiRequestFile { get; set; }
        public string QRFile { get; set; }
        public int QRType { get; set; }
        public int QRFormat { get; set; }
        public decimal QRSize { get; set; }
        public decimal QRFactor { get; set; }
        public int QRHorPomak { get; set; }

        public string GetPassword()
        {
            if (Password == null)
                return null;
            byte[] encodedDataAsBytes = Convert.FromBase64String(Password);
            return Encoding.UTF8.GetString(encodedDataAsBytes);
        }

        public void SetPassword(string Password)
        {
            byte[] toEncodeAsBytes = Encoding.UTF8.GetBytes(Password);
            this.Password = Convert.ToBase64String(toEncodeAsBytes);
        }

        public void SetCertificatePass(string Pass)
        {
            byte[] toEncodeAsBytes = Encoding.UTF8.GetBytes(Pass);
            this.CertificatePass = Convert.ToBase64String(toEncodeAsBytes);
        }

        public string GetCertificatePass()
        {
            if (CertificatePass == null)
                return null;
            byte[] encodedDataAsBytes = Convert.FromBase64String(CertificatePass);
            return Encoding.UTF8.GetString(encodedDataAsBytes);
        }

        public static Configuration Load(string currentPath)
        {
            string path = Path.Combine(currentPath, "config.xml");
            if (!File.Exists(path))
                return new Configuration();

            StreamReader xmlFile = new StreamReader(path);
            string xml = xmlFile.ReadToEnd();
            xmlFile.Close();

            return LoadFromString(xml);
        }

        private static Configuration LoadFromString(string content)
        {
            Configuration ret = new Configuration();
            if (!string.IsNullOrEmpty(content))
            {
                XmlSerializer ser = new XmlSerializer(ret.GetType());
                StringReader stringReader = new StringReader(content);
                XmlTextReader xmlReader = new XmlTextReader(stringReader);
                ret = (Configuration)ser.Deserialize(xmlReader);
                xmlReader.Close();
                stringReader.Close();
            }
            return ret;
        }

        public void Save(string currentPath)
        {
            string xml = SaveToString();

            StreamWriter file = new StreamWriter(Path.Combine(currentPath, "config.xml"));
            file.WriteLine(xml);
            file.Close();
        }

        private string SaveToString()
        {
            string xml = string.Empty;

            XmlSerializer serializer = new XmlSerializer(this.GetType());
            using (StringWriter writer = new StringWriter())
            {
                serializer.Serialize(writer, this);
                xml = writer.ToString();
                writer.Close();
            }
            return xml;
        }

        public Configuration Clone()
        {
            string xml = SaveToString();
            return LoadFromString(xml);
        }

    }
}
