﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Raverus.FiskalizacijaDEV;
using System.Diagnostics;
using System.Xml;
using System.IO;

namespace Fiskalizacija.DOS.SysTray
{
    public partial class ConfigurationForm : Form
    {
        private Configuration config;
        private string currentPath;
        private readonly Stopwatch stopWatch = new Stopwatch();
        private QR qr;

        public bool NeedsRefresh { get; set; }

        public ConfigurationForm(Configuration config, string currentPath, QR qr)
        {
            this.config = config;
            this.currentPath = currentPath;
            this.qr = qr;
            NeedsRefresh = false;
            InitializeComponent();
            this.Icon = new Icon(Properties.Resources.MainIcon, new Size(128, 128));
        }

        private void ConfigurationForm_Load(object sender, EventArgs e)
        {
            txtOIB.Text = config.OIB;
            cbUSustavuPDV.Checked = (config.USustavuPDV == null) ? true : Convert.ToBoolean(config.USustavuPDV);
            txtOznPoslProstora.Text = (config.OznakaPoslProstora == null) ? "1" : config.OznakaPoslProstora;
            txtOznNaplUredjaja.Text = (config.OznakaNaplatnogUredjaja == null) ? "1" : config.OznakaNaplatnogUredjaja;
            rbP.Checked = "P".Equals(config.OznakaSlijednosti);
            rbN.Checked = config.OznakaSlijednosti==null || "N".Equals(config.OznakaSlijednosti);
            txtUlica.Text = config.Ulica;
            txtKucniBroj.Text = config.KucniBroj;
            txtDodatakKucBroj.Text = config.DodatakKucnomBroju == null ? "." : config.DodatakKucnomBroju;
            txtBrojPoste.Text = config.Posta;
            txtNaselje.Text = config.Naselje;
            txtOpcina.Text = config.Opcina;
            txtOstaliTip.Text = config.OstaliTipPP;
            cbNepostojecaAdresa.Checked = config.NepostojecaAdresa;
            this.SakrijAdresu(config.NepostojecaAdresa);
            //txtRadnoVrijeme.Text = config.RadnoVrijeme;
            //if (config.DatumPocetka != null) dtDatumPrimjene.Value = Convert.ToDateTime(config.DatumPocetka, new System.Globalization.CultureInfo("hr-HR"));
            //txtOznakaZatvaranja.Text = config.OznakaZatvaranja;
            txtOIBProgramera.Text = config.OIBprogramera;

            txtCertificateSubject.Text = (config.CertificateSubject == null) ? "FISKAL 1" : config.CertificateSubject.Trim();
            txtCertificatePassword.Text = config.GetCertificatePass();
            txtCertificateFile.Text = config.CertificateFile;
            txtRequestFile.Text = config.RequestFile;
            txtResponseFile.Text = config.ResponseFile;
            txtUrl.Text = (config.Url == null) ? "https://cis.porezna-uprava.hr:8449/FiskalizacijaService" : config.Url;
            txtUrlTocnoVrijeme.Text = (config.UrlTocnoVrijeme == null) ? "http://www.dns.hr" : config.UrlTocnoVrijeme;
            txtLogFolder.Text = config.LogFolder;
            txtPassword.Text = config.GetPassword();
            numTimeout.Value = (config.Timeout < 1 || config.Timeout > 20) ? 9 : config.Timeout;
            numPolling.Value = config.Polling;
            cbOffline.Checked = config.Offline;
            cbKontrolaRB.Checked = (config.KontrolaRB == false) ? false : true;         // stara verzija je null koji mora postati true (default value)
            cbBrisiRequest.Checked = (config.BrisiRequestFile == false) ? false : true; // stara verzija je null koji mora postati true (default value)

            cbQR.Items.Add(new QRItem("Ništa", QRItemType.None));
            cbQR.Items.Add(new QRItem("1.) Nativna Epson ESC sekvenca", QRItemType.Nativni));
            cbQR.Items.Add(new QRItem("2.) GS v sekvenca", QRItemType.GSv));
            cbQR.Items.Add(new QRItem("3.) ESC K sekvenca", QRItemType.ESCK));
            //cbQR.Items.Add(new QRItem("4.) ESC K sekvenca šira", QRItemType.ESCKSire));
            cbQR.Items.Add(new QRItem("4.) ESC * sekvenca", QRItemType.ESCAsterisk));
            //cbQR.Items.Add(new QRItem("6.) ESC * sekvenca šira", QRItemType.ESCAsteriskSire));
            cbQR.Items.Add(new QRItem("5.) Nativna Star ESC sekvenca", QRItemType.NativniStar));
            cbQR.Items.Add(new QRItem("6.) Slika PNG", QRItemType.PNG));
            cbQR.Items.Add(new QRItem("7.) Slika JPG", QRItemType.JPG));
            cbQR.Items.Add(new QRItem("8.) Slika GIF", QRItemType.GIF));
            cbQR.Items.Add(new QRItem("9.) Slika BMP", QRItemType.BMP));
            cbQR.Items.Add(new QRItem("10.) Slika TIF", QRItemType.TIF));
            cbQR.SelectedIndex = 0;
            for (int i=0; i < cbQR.Items.Count; i++)
            {
                if ((int)(cbQR.Items[i] as QRItem).QRItemType == config.QRType)
                {
                    cbQR.SelectedIndex = i;
                    break;
                }
                else if ((cbQR.Items[i] as QRItem).QRItemType == QRItemType.ESCAsterisk && config.QRType == (int)QRItemType.ESCAsteriskSire)
                {
                    cbQR.SelectedIndex = i;     // backward compatibility - convert ESCAsteriskSire to ESCAsterisk
                    break;
                }
                else if ((cbQR.Items[i] as QRItem).QRItemType == QRItemType.ESCK && config.QRType == (int)QRItemType.ESCKSire)
                {
                    cbQR.SelectedIndex = i;     // backward compatibility - convert ESCKSire to ESCK
                    break;
                }
            }
            if ((cbQR.Items[cbQR.SelectedIndex] as QRItem).QRItemType == QRItemType.ESCAsterisk || (cbQR.Items[cbQR.SelectedIndex] as QRItem).QRItemType == QRItemType.ESCK)
            {
                numQRFactor.Enabled = true;
            }
            else
            {
                numQRFactor.Enabled = false;
            }

            //cbQRFormat.Items.Add("QR code");
            //cbQRFormat.Items.Add("PDF417");
            //cbQRFormat.Items.Add("Code 128 (2 reda)");
            //cbQRFormat.Items.Add("Code 128 (3 reda)");
            //cbQRFormat.Items.Add("Code 128 (4 reda)");
            //cbQRFormat.Items.Add("Code 128 (5 reda)");
            //cbQRFormat.Items.Add("Code 128 (6 reda)");
            //cbQRFormat.SelectedIndex = config.QRFormat;

            numQRSize.Value = (config.QRSize < 40) ? 100 : config.QRSize;
            numQRFactor.Value = (config.QRFactor < .1M) ? 1 : config.QRFactor;
            numHorPomak.Value = config.QRHorPomak;
            txtQRFile.Text = config.QRFile;
            if (String.IsNullOrEmpty(txtQRFile.Text))
            {
                //txtQRFile.Text = ".\\QR\\%GOD%\\%DATUM%\\%RACUN%.PRN";
                txtQRFile.Text = ".\\QR.PRN";
            }
        }

        private void btnOdustani_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnSnimi_Click(object sender, EventArgs e)
        {
            config.OIB = txtOIB.Text;
            config.USustavuPDV = cbUSustavuPDV.Checked.ToString();
            config.OznakaPoslProstora = txtOznPoslProstora.Text;
            config.OznakaNaplatnogUredjaja = txtOznNaplUredjaja.Text;
            config.OznakaSlijednosti = (rbN.Checked == true) ? "N" : "P";
            config.NepostojecaAdresa = cbNepostojecaAdresa.Checked;
            config.Ulica = txtUlica.Text;
            config.KucniBroj=txtKucniBroj.Text;
            config.DodatakKucnomBroju=txtDodatakKucBroj.Text;
            config.Posta=txtBrojPoste.Text;
            config.Naselje=txtNaselje.Text;
            config.Opcina=txtOpcina.Text;
            config.OstaliTipPP = txtOstaliTip.Text;
            //config.RadnoVrijeme = txtRadnoVrijeme.Text;
            //config.DatumPocetka = dtDatumPrimjene.Value.ToString(new System.Globalization.CultureInfo("hr-HR"));
            //config.OznakaZatvaranja = (txtOznakaZatvaranja.Text == "Z") ? "Z" : null;
            config.OIBprogramera = txtOIBProgramera.Text;

            config.CertificateSubject = txtCertificateSubject.Text;
            config.SetCertificatePass(txtCertificatePassword.Text);
            config.CertificateFile = txtCertificateFile.Text;
            config.RequestFile = txtRequestFile.Text;
            config.ResponseFile = txtResponseFile.Text;
            config.Url = txtUrl.Text;
            config.UrlTocnoVrijeme = txtUrlTocnoVrijeme.Text;
            config.LogFolder = txtLogFolder.Text;
            config.SetPassword(txtPassword.Text);
            config.Timeout = numTimeout.Value;
            config.Polling = numPolling.Value;
            config.Offline = cbOffline.Checked;
            config.KontrolaRB = cbKontrolaRB.Checked;
            config.BrisiRequestFile = cbBrisiRequest.Checked;
            config.QRType = (int)((cbQR.Items[cbQR.SelectedIndex] as QRItem).QRItemType);
            //config.QRFormat = (int)(cbQRFormat.SelectedIndex);
            config.QRSize = numQRSize.Value;
            config.QRFactor = numQRFactor.Value;
            config.QRHorPomak = (int)numHorPomak.Value;
            config.QRFile = txtQRFile.Text;

            config.Save(currentPath);
            NeedsRefresh = true;
            this.Close();
        }

        private bool isNumeric(string text)
        {
            for (int i=0; i<text.Length; i++)
            {
                if (char.IsDigit(text[i]) == false)
                    return false;
            }
            return true;
        }

        private void btnPosalji_Click(object sender, EventArgs e)
        {
            //// logiraj u file
            //LogFile logFile = new LogFile();
            //if (!logFile.Init(config.LogFolder))
            //    logFile = null;
            //string logFileName = "PoslovniProstor" + DateTime.Now.ToString("HHmmss");

            //// zacrveni polja koja moraju biti numerička
            //if (isNumeric(txtBrojPoste.Text))
            //    txtBrojPoste.BackColor = SystemColors.Window;
            //else
            //    txtBrojPoste.BackColor = Color.Tomato;
            //if (isNumeric(txtKucniBroj.Text))
            //    txtKucniBroj.BackColor = SystemColors.Window;
            //else
            //    txtKucniBroj.BackColor = Color.Tomato;

            //btnPosalji.Enabled = false;
            //Raverus.FiskalizacijaDEV.Schema.PoslovniProstorType poslovniProstor = new Raverus.FiskalizacijaDEV.Schema.PoslovniProstorType() { Oib = txtOIB.Text, OznPoslProstora = txtOznPoslProstora.Text };
            //Raverus.FiskalizacijaDEV.Schema.AdresaType adresa = new Raverus.FiskalizacijaDEV.Schema.AdresaType() { Ulica = txtUlica.Text, KucniBroj = txtKucniBroj.Text, KucniBrojDodatak = txtDodatakKucBroj.Text, BrojPoste = txtBrojPoste.Text, Naselje = txtNaselje.Text, Opcina = txtOpcina.Text };
            //Raverus.FiskalizacijaDEV.Schema.AdresniPodatakType adresniPodatak = null;
            //if (cbNepostojecaAdresa.Checked)
            //    adresniPodatak = new Raverus.FiskalizacijaDEV.Schema.AdresniPodatakType() { Item = txtOstaliTip.Text };
            //else
            //    adresniPodatak = new Raverus.FiskalizacijaDEV.Schema.AdresniPodatakType() { Item = adresa };
            //poslovniProstor.AdresniPodatak = adresniPodatak;
            //poslovniProstor.RadnoVrijeme = txtRadnoVrijeme.Text;
            //poslovniProstor.SpecNamj = txtOIBProgramera.Text;
            //poslovniProstor.DatumPocetkaPrimjene = Raverus.FiskalizacijaDEV.PopratneFunkcije.Razno.FormatirajDatum(dtDatumPrimjene.Value.Date);
            //if (txtOznakaZatvaranja.Text == "Z")
            //{
            //    poslovniProstor.OznakaZatvaranja = Raverus.FiskalizacijaDEV.Schema.OznakaZatvaranjaType.Z;
            //    poslovniProstor.OznakaZatvaranjaSpecified = true;
            //}

            //if (adresa.BrojPoste.Length == 0) adresa.BrojPoste = null;
            //if (adresa.KucniBroj.Length == 0) adresa.KucniBroj = null;
            //if (adresa.KucniBrojDodatak.Length == 0) adresa.KucniBrojDodatak = null;
            //if (adresa.Naselje.Length == 0) adresa.Naselje = null;
            //if (adresa.Opcina.Length == 0) adresa.Opcina = null;
            //if (adresa.Ulica.Length == 0) adresa.Ulica = null;
            //if (poslovniProstor.SpecNamj.Length == 0) poslovniProstor.SpecNamj = null;
            
            //Raverus.FiskalizacijaDEV.CentralniInformacijskiSustav cis = new CentralniInformacijskiSustav();
            //cis.CisUrl = txtUrl.Text;
            //cis.TimeOut = (int)numTimeout.Value * 1000;
            //cis.SoapMessageSending += cis_SoapMessageSending;
            //cis.SoapMessageSent += cis_SoapMessageSent;

            //logFile.Write(DateTime.Now, logFileName + "i", poslovniProstor);
           
            //try
            //{
            //    XmlDocument doc;

            //    if (string.IsNullOrEmpty(txtCertificateSubject.Text))
            //        doc = cis.PosaljiPoslovniProstor(poslovniProstor, Raverus.FiskalizacijaDEV.PopratneFunkcije.Potpisivanje.DohvatiCertifikat(txtCertificateFile.Text, txtCertificatePassword.Text));
            //    else
            //        doc = cis.PosaljiPoslovniProstor(poslovniProstor, txtCertificateSubject.Text);

            //    if (doc != null)
            //    {
            //        logFile.Write(DateTime.Now, logFileName + "o", doc);
            //        MessageBox.Show(this, "Poslano dobro"/*doc.InnerXml*/, "OK", MessageBoxButtons.OK, MessageBoxIcon.Information);
            //    }
            //    else
            //    {
            //        stopWatch.Stop();
            //        MessageBox.Show(this, "GREŠKA SLANJA", "ops", MessageBoxButtons.OK, MessageBoxIcon.Error);
            //        btnPosalji.Enabled = true;
            //    }
            //}
            //catch (Exception ex)
            //{
            //    stopWatch.Stop();
            //    MessageBox.Show(this, ex.Message + "\n" + ex.StackTrace, "greška", MessageBoxButtons.OK, MessageBoxIcon.Error);
            //    btnPosalji.Enabled = true;
            
            //}
        }

        void cis_SoapMessageSending(object sender, CentralniInformacijskiSustavEventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            stopWatch.Start();
            Application.DoEvents();
        }

        void cis_SoapMessageSent(object sender, EventArgs e)
        {
            stopWatch.Stop();
            btnPosalji.Enabled = true;
            lblVrijeme.Text = String.Format("Vrijeme: {0} s", stopWatch.Elapsed.TotalSeconds);
            Application.DoEvents();
            stopWatch.Reset();
            Cursor.Current = Cursors.Default;
        }

        private string getFileName()
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.CheckFileExists = false;
            openFileDialog.CheckPathExists = false;
            openFileDialog.Multiselect = false;
            openFileDialog.ValidateNames = false;
            openFileDialog.RestoreDirectory = true;
            openFileDialog.InitialDirectory = currentPath;
            if (DialogResult.OK == openFileDialog.ShowDialog())
            {
                return openFileDialog.FileName;
            }
            return null;
        }

        private void btnTestVrijeme_Click(object sender, EventArgs e)
        {
            string error, tocnoVrijeme;
            TocnoVrijeme.Get(txtUrlTocnoVrijeme.Text, out tocnoVrijeme, out error);
            if (error != null)
                MessageBox.Show(this, error, "Oops", MessageBoxButtons.OK, MessageBoxIcon.Error);
            else
                MessageBox.Show(this, tocnoVrijeme, "Čitanje točnog vremena", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
        }

        private void btnRequestFile_Click(object sender, EventArgs e)
        {
            string filename = getFileName();
            if (!string.IsNullOrEmpty(filename))
                txtRequestFile.Text = filename;
        }

        private void btnResponseFile_Click(object sender, EventArgs e)
        {
            string filename = getFileName();
            if (!string.IsNullOrEmpty(filename))
                txtResponseFile.Text = filename;
        }

        private void btnCertificateFile_Click(object sender, EventArgs e)
        {
            string filename = getFileName();
            if (!string.IsNullOrEmpty(filename))
                txtCertificateFile.Text = filename;
        }

        private void btnLogFolder_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                txtLogFolder.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void btnQRPRN_Click(object sender, EventArgs e)
        {
            if (txtQRFile.Text.StartsWith(".\\QR."))
            {
                txtQRFile.Text = ".\\%GOD%\\%DATUM%\\%RACUN%.PRN";
            }
            else
            {
                txtQRFile.Text = ".\\QR.PRN";
            }

            QRItem qrItem = cbQR.Items[cbQR.SelectedIndex] as QRItem;
            if (qrItem != null)
            {
                if (tabControl.SelectedIndex == 2)      // samo ako je odabran QR tab
                {
                    switch (qrItem.QRItemType)
                    {
                        case QRItemType.BMP:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "BMP");
                            break;
                        case QRItemType.GIF:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "GIF");
                            break;
                        case QRItemType.JPG:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "JPG");
                            break;
                        case QRItemType.PNG:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "PNG");
                            break;
                        case QRItemType.TIF:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "TIF");
                            break;
                        default:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "PRN");
                            break;
                    }
                }
            }
        }

        private void cbNepostojecaAdresa_CheckedChanged(object sender, EventArgs e)
        {
            this.SakrijAdresu(cbNepostojecaAdresa.Checked);
        }

        private void SakrijAdresu(bool NepostojecaAdresa)
        {
            if (NepostojecaAdresa)
            {
                lblOstaliTip.Visible = true;
                txtOstaliTip.Visible = true;

                lblUlica.Visible = false;
                lblKucniBroj.Visible = false;
                lblDodatakKucBroj.Visible = false;
                lblBrojPoste.Visible = false;
                lblNaselje.Visible = false;
                lblOpcina.Visible = false;
                txtUlica.Visible = false;
                txtKucniBroj.Visible = false;
                txtDodatakKucBroj.Visible = false;
                txtBrojPoste.Visible = false;
                txtNaselje.Visible = false;
                txtOpcina.Visible = false;
            }
            else
            {
                lblOstaliTip.Visible = false;
                txtOstaliTip.Visible = false;

                lblUlica.Visible = true;
                lblKucniBroj.Visible = true;
                lblDodatakKucBroj.Visible = true;
                lblBrojPoste.Visible = true;
                lblNaselje.Visible = true;
                lblOpcina.Visible = true;
                txtUlica.Visible = true;
                txtKucniBroj.Visible = true;
                txtDodatakKucBroj.Visible = true;
                txtBrojPoste.Visible = true;
                txtNaselje.Visible = true;
                txtOpcina.Visible = true;
            }
        }

        private void cbQR_SelectedIndexChanged(object sender, EventArgs e)
        {
            QRItem qrItem = cbQR.Items[cbQR.SelectedIndex] as QRItem;

            if (qrItem == null || String.IsNullOrEmpty(txtQRFile.Text))
            {
                btnTestQR.Enabled = false;
            }
            else
            {
                btnTestQR.Enabled = true;
                if (tabControl.SelectedIndex == 2)      // samo ako je odabran QR tab
                {
                    numQRFactor.Enabled = false;
                    switch (qrItem.QRItemType)
                    {
                        case QRItemType.None:
                            btnTestQR.Enabled = false;
                            break;
                        case QRItemType.ESCAsterisk:
                        case QRItemType.ESCK:
                            numQRFactor.Enabled = true;     // enabliraj desni numeric_up_down 
                            break;
                        case QRItemType.BMP:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "BMP");
                            break;
                        case QRItemType.GIF:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "GIF");
                            break;
                        case QRItemType.JPG:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "JPG");
                            break;
                        case QRItemType.PNG:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "PNG");
                            break;
                        case QRItemType.TIF:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "TIF");
                            break;
                        default:
                            txtQRFile.Text = System.IO.Path.ChangeExtension(txtQRFile.Text, "PRN");
                            break;
                    }
                }
            }
        }

        private void btnTestQR_Click(object sender, EventArgs e)
        {
            string destFile = QR.GetOutputPath(txtResponseFile.Text, txtQRFile.Text, DateTime.Now, "test");
            bool success = qr.WriteQR("https://porezna.gov.hr/rn?zki=9c23efbd9f9b63bc29228ad32eeb27ff&datv=20190113_1159&izn=1000", destFile, (cbQR.Items[cbQR.SelectedIndex] as QRItem).QRItemType, numQRSize.Value, numQRFactor.Value, (int)numHorPomak.Value);
            if (success == true)
            {
                QRItemType qrType = (cbQR.Items[cbQR.SelectedIndex] as QRItem).QRItemType;

                if (qrType == QRItemType.BMP ||
                    qrType == QRItemType.GIF ||
                    qrType == QRItemType.JPG ||
                    qrType == QRItemType.PNG ||
                    qrType == QRItemType.TIF)
                {
                    System.Diagnostics.Process.Start(destFile);
                }
                else
                {
                    QRTestDestination qrDest = new QRTestDestination(destFile);
                    qrDest.Show(this);
                }
            }
        }
        
    }
}
