﻿using System;
using System.Collections.Generic;
using System.Text;
using Raverus.FiskalizacijaDEV;
using System.Xml;

namespace Fiskalizacija.DOS.SysTray
{
    static class Echo
    {
        public static bool Test(SysTrayForm sysTrayForm, Configuration config)
        {
            try
            {
                Raverus.FiskalizacijaDEV.CentralniInformacijskiSustav cis = new CentralniInformacijskiSustav();
                cis.CisUrl = config.Url;
                cis.TimeOut = (int)config.Timeout * 1000;
                XmlDocument doc = cis.PosaljiEcho("");
                if (doc != null)
                {
                    sysTrayForm.ShowBalloon(true, "Ispravno radi veza na poreznu.");
                    return true;
                }
                else
                {
                    sysTrayForm.ShowBalloon(false, "Ne radi veza na poreznu!");
                    return false;
                }
            }
            catch (Exception ex)
            {
                sysTrayForm.ShowBalloon(false, ex.Message);
                return false;
            }
        }

        public static bool Test(Configuration config)
        {
            try
            {
                Raverus.FiskalizacijaDEV.CentralniInformacijskiSustav cis = new CentralniInformacijskiSustav();
                cis.CisUrl = config.Url;
                cis.TimeOut = (int)config.Timeout * 1000;
                XmlDocument doc = cis.PosaljiEcho("");
                if (doc != null)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception)
            {
                return false;
            }
        }
    }
}
