﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace Fiskalizacija.DOS.SysTray
{
    internal class IzvjestajPoDanima
    {
        public Dictionary<DateTime, Dan> Dani { get; set; }
        public Dictionary<int, LogContent.PDV> Pdv { get; set; }
        public Dictionary<string, Dan> Radnici { get; set; }
        public Dictionary<string, int> NacinPlacanja { get; set; }
        public Dictionary<int, List<Racun>> SumnjivBrRacuna { get; set; }
        private Dictionary<string, bool> Zkijevi { get; set; }  // bool je dummy jer ne postoji HashSet<>
        
        public IzvjestajPoDanima()
        {
            Dani = new Dictionary<DateTime, Dan>();
            Pdv = new Dictionary<int, LogContent.PDV>();
            Radnici = new Dictionary<string, Dan>();
            NacinPlacanja = new Dictionary<string, int>();
            SumnjivBrRacuna = new Dictionary<int, List<Racun>>();
            Zkijevi = new Dictionary<string, bool>();
        }

        public void Sumiraj(string racunPath)
        {
            int brojRacunaIzFilenamea = getBrojRacuna(racunPath);
            if (brojRacunaIzFilenamea == -1)     // ako je to npr prijava poslovnog prostora
                return;

            string content = File.ReadAllText(racunPath);
            content = content.Trim(new char[]{' ', '\n', '\r', '\t', '\0'});

            LogContent logContent = null;
            if (content.Length > 3)
            {
                logContent = new LogContent(content);

                if (!logContent.IsValidLog)
                    logContent = null;
            }
            if (logContent != null)
            {
                int iznosBezNaknadnih = 0;
                if (!Zkijevi.ContainsKey(logContent.Zki))
                {
                    iznosBezNaknadnih = logContent.IznosUkupno;
                    Zkijevi.Add(logContent.Zki, false);         // zapamti da je logContent.Zki pročitan
                }

                // promet po danu
                if (Dani.ContainsKey(logContent.Date))
                {
                    Dan dan = Dani[logContent.Date];
                    dan.IznosUkupno += logContent.IznosUkupno;
                    dan.PrviRacun = Math.Min(dan.PrviRacun, logContent.BrRacuna);
                    dan.ZadnjiRacun = Math.Max(dan.ZadnjiRacun, logContent.BrRacuna);
                    dan.BrojevaRacuna += 1;
                    dan.NaknadnihDostava += (logContent.NaknadnaDostava) ? 1 : 0;
                    dan.IznosBezNaknadnih += iznosBezNaknadnih;
                    Dani[logContent.Date] = dan;
                }
                else
                {
                    Dani.Add(logContent.Date, new Dan()
                    {
                        IznosUkupno = logContent.IznosUkupno,
                        PrviRacun = logContent.BrRacuna,
                        ZadnjiRacun = logContent.BrRacuna,
                        BrojevaRacuna = 1,
                        NaknadnihDostava = (logContent.NaknadnaDostava) ? 1 : 0,
                        IznosBezNaknadnih = iznosBezNaknadnih,
                    });
                }
                
                // promet po stopi PDVa
                foreach (LogContent.PDV p in logContent.Pdv)
                {
                    if (Pdv.ContainsKey(p.Stopa))
                    {
                        LogContent.PDV pn = Pdv[p.Stopa];
                        pn.Osnovica += p.Osnovica;
                        pn.Iznos += p.Iznos;
                        Pdv[p.Stopa] = pn;
                    }
                    else
                    {
                        Pdv.Add(p.Stopa, new LogContent.PDV()
                        {
                            Osnovica = p.Osnovica,
                            Iznos = p.Iznos,
                            Stopa = p.Stopa,
                        });
                    }
                }

                // promet po OIBu radnika
                if (Radnici.ContainsKey(logContent.OibOperatera))
                {
                    Dan dan = Radnici[logContent.OibOperatera];
                    dan.IznosUkupno += logContent.IznosUkupno;
                    dan.PrviRacun = Math.Min(dan.PrviRacun, logContent.BrRacuna);
                    dan.ZadnjiRacun = Math.Max(dan.ZadnjiRacun, logContent.BrRacuna);
                    dan.BrojevaRacuna += 1;
                    dan.NaknadnihDostava += (logContent.NaknadnaDostava) ? 1 : 0;
                    dan.StornoIznos += (logContent.IznosUkupno < 0) ? logContent.IznosUkupno : 0;
                    Radnici[logContent.OibOperatera] = dan;
                }
                else
                {
                    Radnici.Add(logContent.OibOperatera, new Dan()
                    {
                        IznosUkupno = logContent.IznosUkupno,
                        PrviRacun = logContent.BrRacuna,
                        ZadnjiRacun = logContent.BrRacuna,
                        BrojevaRacuna = 1,
                        NaknadnihDostava = (logContent.NaknadnaDostava) ? 1 : 0,
                        StornoIznos = (logContent.IznosUkupno < 0) ? logContent.IznosUkupno : 0,
                    });
                }

                // promet po vrsti plaćanja
                if (NacinPlacanja.ContainsKey(logContent.NacinPlacanja))
                {
                    int iznos = NacinPlacanja[logContent.NacinPlacanja];
                    iznos += logContent.IznosUkupno;
                    NacinPlacanja[logContent.NacinPlacanja] = iznos;
                }
                else
                {
                    NacinPlacanja.Add(logContent.NacinPlacanja, logContent.IznosUkupno);
                }
            }
            else
            {
                logContent = new LogContent();  // ponekad je XML file prazan - uzmi ga u obzir kod traženja SumnjivogBrRacuna
            }

            // napuni sve račune u SumnjivBrRacuna[] bez obzira jesu li sumnjivi ili ne
            // služi za traženje dupliciranih računa i rupe u slijedu brojeva računa
            if (SumnjivBrRacuna.ContainsKey(brojRacunaIzFilenamea))
            {
                SumnjivBrRacuna[brojRacunaIzFilenamea].Add(new Racun(logContent.BrRacuna, logContent.DateString, logContent.IznosUkupno, logContent.NaknadnaDostava, logContent.Zki, racunPath));
            }
            else
            {
                SumnjivBrRacuna.Add(brojRacunaIzFilenamea, new List<Racun>(1) { new Racun(logContent.BrRacuna, logContent.DateString, logContent.IznosUkupno, logContent.NaknadnaDostava, logContent.Zki, racunPath) });
            }
        }

        private int getBrojRacuna(string racunPath)
        {
            // pročitaj broj računa iz imena fajla. To moraju biti znamenke na početku imena fajla. Prije slova 'i'.
            string fileName = Path.GetFileName(racunPath);
            char prvoSlovo = fileName[0];
            if (prvoSlovo >= '0' && prvoSlovo <= '9')
            {
                int krajBroja = fileName.IndexOf('i');
                if (krajBroja == -1)
                    return -1;
                int brojRacuna;
                if (!int.TryParse(fileName.Substring(0, krajBroja), out brojRacuna))
                    return -1;
                return brojRacuna;
            }
            else
                return -1;
        }

        internal struct Dan
        {
            public int IznosUkupno;
            public int IznosBezNaknadnih;
            public int PrviRacun;
            public int ZadnjiRacun;
            public int BrojevaRacuna;
            public int NaknadnihDostava;
            public int StornoIznos;
        }

        internal struct Racun
        {
            public Racun(int brojRacuna, string datumVrijeme, int iznosRacuna, bool naknadnaDostava, string zki, string absPath)
            {
                BrojRacuna = brojRacuna;
                DatumVrijeme = datumVrijeme;
                IznosRacuna = iznosRacuna;
                NaknadnaDostava = naknadnaDostava;
                Zki = zki;
                AbsPath = absPath;
            }
            public int BrojRacuna;
            public string DatumVrijeme;
            public int IznosRacuna;
            public bool NaknadnaDostava;
            public string Zki;
            public string AbsPath;  // path log filea
        }
    }
}
