﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Fiskalizacija.DOS.SysTray
{
    /// <summary>
    /// Brzo parsiranje XML-a
    /// </summary>
    internal class LogContent
    {
        private const string RACUNTYPE = "RacunType";
        private const string DATVRIJEME = "DatVrijeme>";
        private const string BROZNRAC = "BrOznRac>";
        private const string ŞTOPA = "<tns:Stopa>";
        private const string OSNOVICA = "tns:Osnovica>";
        private const string IZNOS = "tns:Iznos>";
        private const string IZNOSUKUPNO = "IznosUkupno>";
        private const string NACINPLAC = "NacinPlac>";
        private const string OIBOPER = "OibOper>";
        private const string NAKDOST = "NakDost>";
        private const string ZKI = "ZastKod>";
        
        private string _content;
        int _runner = 0;

        public bool IsValidLog { get; set; }
        public DateTime Date { get; set; }
        public string DateString { get; set; }
        public int BrRacuna { get; set; }
        public List<PDV> Pdv { get; set; }
        public int IznosUkupno { get; set; }
        public string NacinPlacanja { get; set; }
        public string OibOperatera { get; set; }
        public bool NaknadnaDostava { get; set; }
        public string Zki { get; set; }

        public LogContent()
        {
            // inicijaliziraj sve sa null
        }

        public LogContent(string content)
        {
            _content = content;
            IsValidLog = false;

            if (!contains(RACUNTYPE))
                return;

            // parse log XML file - extract values
            DateString = getValue(DATVRIJEME);
            Date = new DateTime(int.Parse(DateString.Substring(6, 4)), int.Parse(DateString.Substring(3, 2)), int.Parse(DateString.Substring(0, 2)));
            BrRacuna = int.Parse(getValue(BROZNRAC));
            
            Pdv = new List<PDV>();
            string stopa;
            while ((stopa = getValueNullable(ŞTOPA)) != null)
            {
                Pdv.Add(new PDV()
                {
                    Stopa = int.Parse(stopa.Replace(".","")),
                    Osnovica = int.Parse(getValue(OSNOVICA).Replace(".","")),
                    Iznos = int.Parse(getValue(IZNOS).Replace(".", "")),
                });
            }

            IznosUkupno = int.Parse(getValue(IZNOSUKUPNO).Replace(".",""));
            NacinPlacanja = getValue(NACINPLAC);
            OibOperatera = getValue(OIBOPER);
            Zki = getValue(ZKI);
            NaknadnaDostava = bool.Parse(getValue(NAKDOST));
            
            IsValidLog = true;
        }

        private string getValue(string tag)
        {
            int start = _content.IndexOf(tag, _runner);
            if (start == -1)
                throw new Exception("Ne mogu naći početak " + tag + " u XML-u");
            start += tag.Length;
            int end = _content.IndexOf("</", start);
            if (end == -1) throw new Exception("Ne mogu naći kraj " + tag + " u XML-u");
            _runner = end;
            return _content.Substring(start, end - start);
        }

        private string getValueNullable(string tag)
        {
            int start = _content.IndexOf(tag, _runner);
            if (start == -1) return null;
            start += tag.Length;
            int end = _content.IndexOf("</", start);
            if (end == -1) return null;
            _runner = end;
            return _content.Substring(start, end - start);
        }

        private bool contains(string tag)
        {
            int start = _content.IndexOf(tag, _runner);
            if (start == -1)
                return false;
            
            _runner = start;
            return true;
        }

        internal struct PDV
        {
            public int Stopa;
            public int Osnovica;
            public int Iznos;
        }
    }
}
