﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Raverus.FiskalizacijaDEV.Schema;
using System.Xml;

namespace Fiskalizacija.DOS.SysTray
{
    public class LogFile
    {
        private string folder = null;
        private bool isOk = false;

        public bool Init(string folder)
        {
            if (string.IsNullOrEmpty(folder))
                return true;

            if (Directory.Exists(folder))
            {
                isOk = true;
                this.folder = folder;
            }
            return isOk;
        }

        public static string[] GetFoldersForYear(string logFolder, DateTime datumOd)
        {
            string[] daysFolders = null;
            string yearFolder = Path.Combine(logFolder, datumOd.ToString("yyyy"));
            if (Directory.Exists(yearFolder))
                daysFolders = Directory.GetDirectories(yearFolder);                  // normalni subfolder godine
            string[] daysFoldersOldVersion = Directory.GetDirectories(logFolder);    // stara verzija kad se log nije snimao u subfolder godine nego je dan bio u subfolder nivou LOG foldera

            if (daysFolders == null)
                return daysFoldersOldVersion;
            else
            {
                // napravi merge daysFoldersOldVersion u daysFolders
                int array1OriginalLength = daysFolders.Length;
                Array.Resize<string>(ref daysFolders, array1OriginalLength + daysFoldersOldVersion.Length);
                Array.Copy(daysFoldersOldVersion, 0, daysFolders, array1OriginalLength, daysFoldersOldVersion.Length);
                return daysFolders;
            }
        }

        private string checkLogFolder(DateTime dt)
        {
            string logFolderTop = Path.Combine(folder, dt.ToString("yyyy"));
            if (!Directory.Exists(logFolderTop))
            {
                Directory.CreateDirectory(logFolderTop);
            }
            string logFolder = Path.Combine(logFolderTop, dt.ToString("yyMMdd"));
            if (!Directory.Exists(logFolder))
            {
                Directory.CreateDirectory(logFolder);
            }
            return logFolder;
        }

        private string correctLogFilename(DateTime dt, string filename)
        {
            string newFilename = Path.Combine(checkLogFolder(dt), filename.Replace('\\', '_').Replace('/', '_') + ".XML");
            if (File.Exists(newFilename))
            {
                newFilename = Path.Combine(checkLogFolder(dt), filename.Replace('\\', '_').Replace('/', '_') + "_" + DateTime.Now.Ticks.ToString() + ".XML");
            }
            return newFilename;
        }

        public string Write(DateTime dt, string filename, string content)
        {
            if (!isOk)
                return null;

            string error = null;
            try
            {
                using (StreamWriter logfile = new StreamWriter(correctLogFilename(dt, filename)))
                {
                    logfile.Write(content);
                }
            }
            catch (Exception ex)
            {
                error = "LogFile: " + ex.Message;
            }
            return error;
        }

        public string Write(DateTime dt, string filename, RacunType racun)
        {
            if (!isOk)
                return null;

            string error = null;
            try
            {
                racun.SaveToFile(correctLogFilename(dt, filename));
            }
            catch (Exception ex)
            {
                error = "LogFile: " + ex.Message;
            }
            return error;
        }

        public string Write(DateTime dt, string filename, RacunNapojnicaType napoj)
        {
            if (!isOk)
                return null;

            string error = null;
            try
            {
                napoj.SaveToFile(correctLogFilename(dt, filename));
            }
            catch (Exception ex)
            {
                error = "LogFile: " + ex.Message;
            }
            return error;
        }

        public string Write(DateTime dt, string filename, PoslovniProstorType poslovniProstor)
        {
            if (!isOk)
                return null;

            string error = null;
            try
            {
                poslovniProstor.SaveToFile(correctLogFilename(dt, filename));
            }
            catch (Exception ex)
            {
                error = "LogFile: " + ex.Message;
            }
            return error;
        }

        public string Write(DateTime dt, string filename, PrijaviRadnoVrijemeZahtjev radnoVrijeme)
        {
            if (!isOk)
                return null;

            string error = null;
            try
            {
                radnoVrijeme.SaveToFile(correctLogFilename(dt, filename));
            }
            catch (Exception ex)
            {
                error = "LogFile: " + ex.Message;
            }
            return error;
        }

        public string Write(DateTime dt, string filename, XmlDocument xmlDoc)
        {
            if (!isOk)
                return null;

            string error = null;
            try
            {
                XmlTextWriter writer = new XmlTextWriter(correctLogFilename(dt, filename), Encoding.UTF8);
                writer.Formatting = Formatting.Indented;
                xmlDoc.Save(writer);
                writer.Close();
            }
            catch (Exception ex)
            {
                error = "LogFile: " + ex.Message;
            }
            return error;
        }
        
        
    }
}
