﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiskalizacija.DOS.SysTray
{
    public partial class LogForm : Form
    {
        private LogData logData = new LogData();
        private IntPtr dummyHandle;
        private string clipboard;

        public LogForm()
        {
            InitializeComponent();
            this.Icon = new Icon(Properties.Resources.MainIcon, new Size(128, 128));
            dummyHandle = listView1.Handle;
        }

        private void LogForm_Load(object sender, EventArgs e)
        {
            listView1.View = View.Details;
            //listView1.GridLines = true;
            listView1.FullRowSelect = true;

            //Add column header
            listView1.Columns.Add("Vrijeme", 80);
            listView1.Columns.Add("Poruka", 2000);
        }

        private void LogForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)       // odvoji UserClosing od WindowsShutdown ponašanje
            {
                this.Hide();
                e.Cancel = true; // this cancels the close event.
            }
        }

        public void Add(bool isOk, string message)
        {            
            listView1.BeginInvoke(new InvokeDelegate(InvokeMethod), isOk, message);
        }

        // Koristimo InvokeMethod jer se Add() poziva iz drugog threada. Kad bi bilo iz istog threada nebi trebalo InvokeMethod
        public delegate void InvokeDelegate(bool isOk, string message);
        private void InvokeMethod(bool isOk, string message)
        {
            ListViewItem item;

            item = new ListViewItem(new string[] { DateTime.Now.ToString("HH:mm:ss"), message });
            if (isOk == false)
                item.ForeColor = Color.Red;
            listView1.Items.Add(item);
        }

        // Handler za desni klik miša
        private void listView1_MouseClick(object sender, MouseEventArgs e)
        {
            ListViewItem item=null;
            if (e.Button == MouseButtons.Right)
            {
                listView1.ContextMenuStrip = null;
                item = listView1.GetItemAt(e.X, e.Y);
                if (item!=null)
                    contextMenuStrip1.Show(MousePosition);
            }
            if (item != null)
            {
                clipboard = item.SubItems[1].Text;
            }
        }

        private void contextMenuStrip1_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(clipboard);
        }
     
    }

    class LogData
    {
        private volatile bool isOk;
        private volatile string message;

        public bool IsOk
        { get { return isOk; } set { isOk = value; } }
        public string Message
        { get { return message; } set { message = value; } }
    }
}
