﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiskalizacija.DOS.SysTray
{
    public partial class PasswordForm : Form
    {
        private Configuration config;

        public PasswordForm(Configuration config)
        {
            this.config = config;

            InitializeComponent();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (txtPassword.Text.Equals(config.GetPassword()))
                this.Close();
            else
            {
                txtPassword.BackColor = Color.OrangeRed;
                this.DialogResult = DialogResult.Abort;
            }
        }

        private void PasswordForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.Abort)
            {
                e.Cancel = true;
                this.DialogResult = DialogResult.None;     // poništi DialogResult.None jer inače će biti problema kad se windowsXP restarta
            }
        }
    }
}
