﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO.Ports;
using System.Diagnostics;

namespace Fiskalizacija.DOS.SysTray
{
    public partial class QRTestDestination : Form
    {
        private string destFile;

        public QRTestDestination(string destFile)
        {
            this.destFile = destFile;
            InitializeComponent();

            lbDest.Items.Add("com1");
            lbDest.Items.Add("com2");
            lbDest.Items.Add("com3");
            lbDest.Items.Add("com4");
            lbDest.Items.Add("lpt1");
            lbDest.Items.Add("lpt2");
            foreach (string printer in System.Drawing.Printing.PrinterSettings.InstalledPrinters)
            {
                lbDest.Items.Add(printer);
            }
            lbDest.SelectedIndex = 0;

            this.Icon = new Icon(Properties.Resources.MainIcon, new Size(128, 128));
        }

        private static void ExecuteCommand(string command)
        {
            var processInfo = new ProcessStartInfo("cmd.exe", "/c " + command);
            processInfo.CreateNoWindow = true;
            processInfo.UseShellExecute = false;
            processInfo.RedirectStandardError = true;
            processInfo.RedirectStandardOutput = true;

            var process = Process.Start(processInfo);
            string dataMessage = "";
            string errMessage = "";

            process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
                dataMessage += e.Data + "\n";
            process.BeginOutputReadLine();

            process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
                errMessage += e.Data + "\n";
            process.BeginErrorReadLine();

            process.WaitForExit();

            bool isError = (process.ExitCode != 0);

            process.Close();

            if (isError)
            {
                throw new Exception(String.Format("{0}{1}", errMessage, dataMessage));
            }
        }

        private void btnPrintaj_Click(object sender, EventArgs e)
        {
            string printer = (string)lbDest.SelectedItem;
            switch (printer)
            {
                case "com1":
                case "com2":
                case "com3":
                case "com4":
                    try
                    {
                        var bytes = System.IO.File.ReadAllBytes(destFile);
                        SerialPort COM = new SerialPort(printer);
                        COM.Open();
                        COM.Write(bytes, 0, bytes.Length);
                        COM.Close();
                    }
                    catch(Exception ex)
                    {
                        MessageBox.Show(this, ex.Message, "Greška slanja na COM port", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    break;
                case "lpt1":
                case "lpt2":
                    try
                    {
                        ExecuteCommand(String.Format("copy \"{0}\" {1}", destFile, printer));
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(this, ex.Message, "Greška kopiranja na LPT port", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    break;
                default:
                    try
                    {
                        RawPrinterHelper.SendFileToPrinter(printer, destFile);
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(this, ex.Message, printer, MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    break;
            }


        }
    }
}
