﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Net;
using Raverus.FiskalizacijaDEV;
using System.Xml;
using System.IO;
using System.Diagnostics;
using Raverus.FiskalizacijaDEV.Schema;
using System.Globalization;
using System.Security.Cryptography.X509Certificates;
using Microsoft.Win32;
using ZXing;

namespace Fiskalizacija.DOS.SysTray
{
    class RacunWorker
    {
        private const string REG_KEY = @"Software\Fiska";
        private BackgroundWorker worker;
        private SysTrayForm sysTrayForm;
        private volatile FileSystemWatcher watcher = null;
        private LogFile logFile = new LogFile();
        private Configuration config;
        private System.Threading.Mutex mutex;
        private DateTime zadnjiRacDatum;
        private int zadnjiRacBroj;
      
        public RacunWorker(SysTrayForm sysTrayForm, Configuration config)
        {
            this.sysTrayForm = sysTrayForm;
            this.config = config;

            if (config.BrisiRequestFile == true)
            {
                deleteFile(config.RequestFile);
            }

            // Nemoj nastaviti ako već postoji neki drugi proces koji već čita isti request file.
            // To se može desiti ako je već startana ova aplikacija od prije.
            mutex = new System.Threading.Mutex(false, "Global\\dosystray" + config.RequestFile.Replace("\\","_").Replace(":", "-"));
            if (!mutex.WaitOne(0, false))
            {
                return;
            }

            // čak ako se ne može logirati u file, program mora nastaviti raditi
            if (!logFile.Init(config.LogFolder))
            {
                LogError("Ne može se logirati u " + config.LogFolder);
            }

            // postavi vrijednost zadnjiRacDatum i zadnjiRacBroj
            CitajZadnjiRacunIzRegistry();

            // pokreni novi background worker
            worker = new BackgroundWorker();
            worker.WorkerSupportsCancellation = true;
            worker.DoWork += new DoWorkEventHandler(worker_DoWork);
            worker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(worker_Completed);
            worker.RunWorkerAsync();
            startaoOk = true;
        }

        public bool startaoOk { get; set; }

        public void Stop()
        {
            if (worker != null)
                worker.CancelAsync();
        }

        // Ovdje je početak background workera, koji čita file i šalje na CIS
        private void worker_DoWork(object sender, DoWorkEventArgs e)
        {
            System.Threading.Thread.Sleep(100);        // desetinka sekunde inicijalno da se stvari slegnu

            // izvrši echo test
            if (!sysTrayForm.IsOfflineMode)
                Echo.Test(sysTrayForm, config);

            if (config.Polling == 0)    // file watcher mode
            {
                // postavi watcher na request file
                try
                {
                    watcher = new FileSystemWatcher();
                    watcher.Path = Path.GetDirectoryName(config.RequestFile);
                    watcher.Filter = Path.GetFileName(config.RequestFile);
                    watcher.NotifyFilter = NotifyFilters.CreationTime | NotifyFilters.LastAccess | NotifyFilters.LastWrite | NotifyFilters.FileName;
                    watcher.IncludeSubdirectories = false;
                    watcher.Error += new ErrorEventHandler(OnWatcherError);
                    watcher.Changed += new FileSystemEventHandler(OnWatcherInputChanged);
                    watcher.Created += new FileSystemEventHandler(OnWatcherInputChanged);

                    // begin watching
                    watcher.EnableRaisingEvents = true;
                }
                catch (Exception ex)
                {
                    LogError("Watcher greška: " + ex.Message);
                }

                // vrti se u petlji zauvjek dok neko ne pozove Stop()
                while (true)
                {
                    System.Threading.Thread.Sleep(100);
                    if ((worker.CancellationPending == true))
                    {
                        e.Cancel = true;
                        return;
                    }
                }
            }
            else    // file polling mode
            {
                int loopCount = (int)(config.Polling * 1000) / 100;
                while (true)
                {
                    for (int i = 0; i < loopCount; i++)
                    {
                        System.Threading.Thread.Sleep(100);
                        if ((worker.CancellationPending == true))
                        {
                            e.Cancel = true;
                            return;
                        }
                    }
                    if (File.Exists(config.RequestFile))
                    {
                        try
                        {
                            obradiRequestFile();
                        }
                        catch (Exception ex)
                        {
                            LogError("Nehendlana greška: " + ex.Message);   // ne smije se desiti
                        }
                    }
                }
            }
        }

        // ovo okine watcher kod promjene request filea
        private void OnWatcherInputChanged(object source, FileSystemEventArgs e)
        {
            try
            {
                watcher.EnableRaisingEvents = false;    // spriječi duplo pozivanje ovog handlera
                System.Threading.Thread.Sleep(80);      // pričekaj malo da se file napuni - za slučaj da je file kreiran ali ne i napunjen

                obradiRequestFile();
            }
            catch (Exception ex)
            {
                LogError("Nehendlana greška: " + ex.Message);   // ne smije se desiti
            }
            finally
            {
                watcher.EnableRaisingEvents = true;
            }
        }

        private void OnWatcherError(object sender, ErrorEventArgs e)
        {
            LogError("Watcher err: " + e.GetException().Message);
        }

        private void obradiRequestFile()
        {
            string content = readFile();
            if (string.IsNullOrEmpty(content.Trim()))
            {
                LogError("Neuspjelo čitanje " + Path.GetFileName(config.RequestFile));
                return;
            }

            sysTrayForm.LogForm.Add(true, "Zahtjev: " + content);
            
            if (content.StartsWith("DATUM"))                                // ulazni file sa sadržajem "DATUM"
            {
                string error, tocnoVrijeme;
                TocnoVrijeme.Get(config.UrlTocnoVrijeme, out tocnoVrijeme, out error);
                if (error != null)
                {
                    LogError(error);
                    tocnoVrijeme = "GRESKA";
                }
                else
                    sysTrayForm.LogForm.Add(true, "Odgovor: " + tocnoVrijeme);

                writeFile(tocnoVrijeme);
            }
            else if (content.StartsWith("ECHO"))                           // ulazni file sa sadržajem "ECHO"
            {
                if (Echo.Test(config))
                    writeFile("OK");
                else
                    writeFile("GRESKA");
            }
            else if (content.StartsWith("<?xml version"))                   // XML ulazni file
            {
                string jir = obradiRacunXml(content);
                sysTrayForm.LogForm.Add(true, "Odgovor: " + jir);
                writeFile(jir);
            }
            else                                                            // plain text ulazni file
            {
                string jir = obradiRacun(content);
                sysTrayForm.LogForm.Add(true, "Odgovor: " + jir);
                writeFile(jir);
            }
        }

        private string obradiRacun(string input)
        {
            string odgovor = formatOdgovor("", "", "", "");
            
            string[] redovi = input.Split('\n');
            for (int i=0; i<redovi.Length; i++)
                redovi[i] = redovi[i].Trim();

            if (redovi.Length < 10)
            {
                LogError("request file mora imati bar 11 redova (ima " + redovi.Length.ToString() + ")");
                return odgovor;
            }

            // tip requesta
            bool isNakDost = false;
            bool isZkiMode = false;
            bool isQr = false;
            bool isQrBmp = false;
            bool isNapojnica = false;
            if (redovi[0] == "R")
                isNakDost = false;
            else if (redovi[0] == "P")
                isNakDost = true;
            else if (redovi[0] == "N")
                isNapojnica = true;
            else if (redovi[0] == "NP")
            {   isNapojnica = true;
                isNakDost = true;
            }
            else if (redovi[0] == "Z")
                isZkiMode = true;
            else if (redovi[0] == "qr")
                isQr = isZkiMode = true;
            else if (redovi[0] == "qrbmp")
                isQrBmp = isZkiMode = true;
            else
            {
                LogError("1. ne podržavam tip filea " + redovi[0]);
                return odgovor;
            }

            // datum i vrijeme računa
            DateTime dtRacuna;
            try
            {
                string datumVrijeme = redovi[1].Replace("  ", " ");
                dtRacuna = DateTime.ParseExact(datumVrijeme, "d'/'M'/'yyyy H':'m':'s", null);

                if ((config.KontrolaVremena == null || config.KontrolaVremena.Value == true) && !isNakDost && !isQrBmp && !isQr && !isNapojnica && !isZkiMode)
                {
                    // 101 - 'Datum i vrijeme slanja' je za više od 6 sati manje ili veće od 'Datum i vrijeme obrade'.
                    // 103 - 'Datum i vrijeme izdavanja' računa je za više od 6 sati veće od 'Datum i vrijeme obrade'.
                    var hours = Math.Abs((dtRacuna - DateTime.Now).TotalHours);
                    if (hours > 1)
                    {
                        LogError(String.Format("Krivo vrijeme {0}. Restartajte kasu.", dtRacuna.ToString("G")));
                        return odgovor;
                    }
                }

                if (!isNakDost && !isQrBmp && !isQr && !isNapojnica && zadnjiRacDatum > dtRacuna)
                {
                    LogError(String.Format("Sumnjiv datum računa ({0}). Zadnji datum je bio {1}. \n(Ako je ovo lažna uzbuna izbrišite registry HKCU\\Software\\Fiska i restartajte Fisku)", dtRacuna.ToShortDateString(), zadnjiRacDatum.ToShortDateString()));
                    if (!sysTrayForm.IsOfflineMode) return odgovor;     // pusti dalje ako je Offline mode tako da user ima bar neku mogućnost da nastavi
                }
            }
            catch (Exception)
            {
                LogError("2. krivi format datuma ili vremena: " + redovi[1]);
                return odgovor;
            }

            // broj računa
            string brracuna = redovi[2];
            int brracunaInt;
            if (string.IsNullOrEmpty(brracuna) || !Int32.TryParse(brracuna, out brracunaInt))
            {
                LogError("3. krivi broj računa");
                return odgovor;
            }
            else
            {
                if (!isNakDost && !isQrBmp && !isQr && !isNapojnica && zadnjiRacBroj >= brracunaInt)
                {
                    LogError(String.Format("Sumnjiv broj računa ({0}). Zadnji broj je bio {1}. \n(Ako je ovo lažna uzbuna izbrišite registry HKCU\\Software\\Fiska i restartajte Fisku)", brracuna, zadnjiRacBroj));
                    if (!sysTrayForm.IsOfflineMode) return odgovor;     // pusti dalje ako je Offline mode tako da user ima bar neku mogućnost da nastavi
                }
            }

            // porezi (PDV) trimaj
            string[] pdvi = redovi[3].Split(';');
            for (int i = 0; i < pdvi.Length; i++)
                pdvi[i] = pdvi[i].Trim();
            if (pdvi.Length > 1 && pdvi.Length % 3 != 0)
            {
                LogError("4. neispravan broj kolona vrijednosti PDVa (" + pdvi.Length + ")");
                return odgovor;
            }

            // OIB operatera
            if (redovi[6].Length != 11)
            {
                LogError("7. krivi OIB operatera: " + redovi[6]);
                return odgovor;
            }

            // porez na potrošnju trimaj
            string[] ppot = redovi[7].Split(';');
            for (int i = 0; i < ppot.Length; i++)
                ppot[i] = ppot[i].Trim();
            if (ppot.Length > 1 && ppot.Length % 3 != 0)
            {
                LogError("8. neispravan broj kolona poreza na potrošnju (" + ppot.Length + ")");
                return odgovor;
            }

            // naknada ambalaže trimaj
            string[] naknada = redovi[8].Split(';');
            for (int i = 0; i < naknada.Length; i++)
                naknada[i] = naknada[i].Trim();
            if (naknada.Length > 2)
            {
                LogError("9. naknada ambalaže mora imati format \"naknada ambalaže;0,50\" (" + naknada.Length + ")");
                return odgovor;
            }

            // oznaka slijednosti
            OznakaSlijednostiType slijednostTip;
            if (config.OznakaSlijednosti == "N")
                slijednostTip = Raverus.FiskalizacijaDEV.Schema.OznakaSlijednostiType.N;
            else
                slijednostTip = Raverus.FiskalizacijaDEV.Schema.OznakaSlijednostiType.P;

            // tip plaćanja
            NacinPlacanjaType placType;
            if (redovi[5] == "G")
                placType = NacinPlacanjaType.G;
            else if (redovi[5] == "O")
                placType = NacinPlacanjaType.O;
            else if (redovi[5] == "K")
                placType = NacinPlacanjaType.K;
            else if (redovi[5] == "C")
                placType = NacinPlacanjaType.C;
            else if (redovi[5] == "T")
                placType = NacinPlacanjaType.T;
            else
            {
                LogError("neispravni tip plaćanja " + redovi[5]);
                return odgovor;
            }

            // neoporezivo
            string neoporezivo = null;
            if (redovi.Length > 10 && redovi[10].Length > 0)
                neoporezivo = redovi[10];

            // Kontrolni broj
            string kontrolniBroj = null;
            if (redovi.Length > 11 && redovi[11].Length > 0)
            {
                kontrolniBroj = redovi[11];
            }

            // ZKI ako je poznat (poznat je kod ponovnog slanja računa)
            string zki = string.Empty;
            if (redovi.Length > 12 && redovi[12].Length > 0)
            {
                zki = redovi[12];
            }

            // JIR ako je poznat (poznat je kod komande "qr" i kopije računa)
            string jirStari = string.Empty;
            if (redovi.Length > 13 && redovi[13].Length > 0)
            {
                jirStari = redovi[13];
            }

            bool kreirajQR = (isNapojnica) ? false : true;
            if (redovi.Length > 14 && redovi[14].Length > 0)
            {
                if (redovi[14] == "0")
                {
                    kreirajQR = false;
                }
            }

            string oibPrimateljaRacuna = string.Empty;
            if (redovi.Length > 17 && redovi[17].Length > 0)
            {
                oibPrimateljaRacuna = redovi[17];
            }


            // oslobodjeno poreza (novo - još nije dokumentirano)
            string oslobodjeno = null;
            //if (redovi.Length > 13 && redovi[13].Length > 0)
            //    oslobodjeno = redovi[13];



            X509Certificate2 certifikat = CertificateStore();
            if (certifikat == null)
            {
                if (string.IsNullOrEmpty(config.CertificateSubject))
                    LogError("ne mogu čitati certifikat file " + config.CertificateFile);
                else
                    LogError("nepostojeći certifikat subject " + config.CertificateSubject);
                return odgovor;
            }

            // izgradi zahtjev za slanje računa
            RacunType racun;
            try
            {
                racun = new RacunType() { Oib = config.OIB, USustPdv = Convert.ToBoolean(config.USustavuPDV), DatVrijeme = Raverus.FiskalizacijaDEV.PopratneFunkcije.Razno.FormatirajDatumVrijeme(dtRacuna), OznSlijed = slijednostTip, };
                BrojRacunaType br = new BrojRacunaType() { BrOznRac = brracuna, OznPosPr = config.OznakaPoslProstora, OznNapUr = config.OznakaNaplatnogUredjaja };
                racun.BrRac = br;

                if (pdvi.Length >= 3)
                {
                    PdvType pdv = new PdvType();
                    for (int i = 0; i < pdvi.Length; i += 3)
                    {
                        PorezType porez = new PorezType() { Stopa = pdvi[i].Replace(',','.'), Osnovica = pdvi[i + 1].Replace(',','.'), Iznos = pdvi[i + 2].Replace(',','.') };
                        pdv.Porez.Add(porez);
                        racun.Pdv.Add(porez);
                    }
                }

                if (ppot.Length >= 3)
                {
                    PdvType pnp = new PdvType();
                    for (int i = 0; i < ppot.Length; i += 3)
                    {
                        PorezType porez = new PorezType() { Stopa = ppot[i].Replace(',','.'), Osnovica = ppot[i + 1].Replace(',','.'), Iznos = ppot[i + 2].Replace(',','.') };
                        pnp.Porez.Add(porez);
                        racun.Pnp.Add(porez);
                    }
                }
                
                if (naknada.Length == 2)
                {
                     NaknadaType nak = new NaknadaType() {  NazivN = naknada[0].Trim(), IznosN = naknada[1].Trim().Replace(',','.') };
                     racun.Naknade.Add(nak);
                }

                if (redovi[9].Length > 0)
                {
                    racun.ParagonBrRac = redovi[9];
                }

                if (!string.IsNullOrEmpty(neoporezivo))
                {
                    racun.IznosNePodlOpor = neoporezivo;
                }
                if (!string.IsNullOrEmpty(oslobodjeno))
                {
                    racun.IznosOslobPdv = oslobodjeno;
                }

                racun.IznosUkupno = redovi[4].Replace(',','.');
                racun.NacinPlac = placType;
                racun.OibOper = redovi[6];
                racun.NakDost = isNakDost;
                if (!string.IsNullOrEmpty(oibPrimateljaRacuna))
                    racun.OibPrimateljaRacuna = oibPrimateljaRacuna;
                if (zki.Length < 32)
                    zki = Raverus.FiskalizacijaDEV.PopratneFunkcije.Razno.ZastitniKodIzracun(certifikat, racun.Oib, racun.DatVrijeme.Replace('T', ' '), racun.BrRac.BrOznRac, racun.BrRac.OznPosPr, racun.BrRac.OznNapUr, racun.IznosUkupno.ToString());
                racun.ZastKod = zki;

            }
            catch (Exception ex)
            {
                LogError(ex.Message);
                return odgovor;
            }

            if (kreirajQR)
            {
                bool success = writeQR(racun, jirStari, isQrBmp);
                if (!success)
                {
                    return odgovor;
                }
            }


            if (!isZkiMode && !sysTrayForm.IsOfflineMode)
            {
                odgovor = formatOdgovor("", "", zki, kontrolniBroj);
                string logErr;
                CentralniInformacijskiSustav cis = new CentralniInformacijskiSustav();
                Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum tipOdgovora = Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum.NapojnicaOdgovor;
                cis.CisUrl = config.Url;
                cis.TimeOut = (int)config.Timeout * 1000;

                try
                {
                    if (!isNapojnica)
                    {
                        // logiraj racun zahtjev u XML file
                        logErr = logFile.Write(dtRacuna, brracuna + "i", racun);
                        if (logErr != null) LogError(logErr);


                        // pošalji XML račun na CIS
                        tipOdgovora = Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum.RacunOdgovor;
                        XmlDocument odgovorXml = cis.PosaljiRacun(racun, certifikat);    // tu se čeka odgovor CISa
                        if (odgovorXml != null)
                        {
                            string jir = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiJir(odgovorXml);
                            string uuid = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiUuid(odgovorXml, tipOdgovora);
                            odgovor = formatOdgovor(jir, uuid, zki, kontrolniBroj);
                            sysTrayForm.SetIcon(true);

                            // logiraj odgovor u XML file
                            logErr = logFile.Write(dtRacuna, brracuna + "o", odgovorXml);
                            if (logErr != null) LogError(logErr);

                            // upiši zadnji datum i brracuna u registry
                            if (!isNakDost && config.KontrolaRB != false) UpisiZadnjiRacunURegistry(dtRacuna, brracunaInt);
                        }
                        else
                        {
                            LogError("Greška dohvata JIRa");
                        }
                    }
                    else
                    {
                        tipOdgovora = Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum.NapojnicaOdgovor;
                        RacunNapojnicaType napoj = new RacunNapojnicaType()
                        {
                            Oib = racun.Oib,
                            USustPdv = racun.USustPdv,
                            DatVrijeme = racun.DatVrijeme,
                            OznSlijed = racun.OznSlijed,
                            BrRac = racun.BrRac,
                            Pdv = racun.Pdv,
                            Pnp = racun.Pnp,
                            OstaliPor = racun.OstaliPor,
                            IznosOslobPdv = racun.IznosOslobPdv,
                            IznosMarza = racun.IznosMarza,
                            IznosNePodlOpor = racun.IznosNePodlOpor,
                            Naknade = racun.Naknade,
                            IznosUkupno = racun.IznosUkupno,
                            NacinPlac = racun.NacinPlac,
                            OibOper = racun.OibOper,
                            ZastKod = racun.ZastKod,
                            NakDost = racun.NakDost,
                            ParagonBrRac = racun.ParagonBrRac,
                            SpecNamj = racun.SpecNamj,
                        };
                        napoj.Napojnica.iznosNapojnice = "0.00";
                        if (redovi.Length > 15 && redovi[15].Length > 0)
                        {
                            napoj.Napojnica.iznosNapojnice = redovi[15];
                        }
                        napoj.Napojnica.nacinPlacanjaNapojnice = NacinPlacanjaType.O;
                        if (redovi.Length > 16 && redovi[16].Length > 0)
                        {
                            if (redovi[16] == "G")
                                napoj.Napojnica.nacinPlacanjaNapojnice = NacinPlacanjaType.G;
                            else if (redovi[16] == "O")
                                napoj.Napojnica.nacinPlacanjaNapojnice = NacinPlacanjaType.O;
                            else if (redovi[16] == "K")
                                napoj.Napojnica.nacinPlacanjaNapojnice = NacinPlacanjaType.K;
                            else if (redovi[16] == "C")
                                napoj.Napojnica.nacinPlacanjaNapojnice = NacinPlacanjaType.C;
                            else if (redovi[16] == "T")
                                napoj.Napojnica.nacinPlacanjaNapojnice = NacinPlacanjaType.T;
                            else
                            {
                                LogError("neispravni tip plaćanja napojnice " + redovi[16]);
                                return odgovor;
                            }
                        }

                        // logiraj napojnica zahtjev u XML file
                        logErr = logFile.Write(dtRacuna, brracuna + "iN", napoj);
                        if (logErr != null) LogError(logErr);


                        // pošalji XML napojnicu na CIS
                        XmlDocument odgovorXml = cis.PosaljiNapojnicu(napoj, certifikat);    // tu se čeka odgovor CISa
                        if (odgovorXml != null)
                        {
                            string sifraGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiSifruGreske(odgovorXml, tipOdgovora);
                            string porukaGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiPorukuGreske(odgovorXml, tipOdgovora);
                            string uuid = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiUuid(odgovorXml, tipOdgovora);
                            odgovor = formatOdgovor(sifraGreske, uuid, zki, kontrolniBroj);
                            sysTrayForm.SetIcon(true);

                            // logiraj odgovor u XML file
                            logErr = logFile.Write(dtRacuna, brracuna + "oN", odgovorXml);
                            if (logErr != null)
                                LogError(logErr);
                            else if (!String.IsNullOrEmpty(porukaGreske))
                                LogError("Napojnica: "+porukaGreske);
                        }
                        else
                        {
                            LogError("Greška dohvata odgovora Napojnice");
                        }
                    }
                }
                catch (Exception ex)
                {
                    logErr = ex.Message;
                    if (cis.OdgovorGreska != null)
                    {
                        string sifraGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiSifruGreske(cis.OdgovorGreska, tipOdgovora);
                        if (!string.IsNullOrEmpty(sifraGreske))
                        {
                            string porukaGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiPorukuGreske(cis.OdgovorGreska, tipOdgovora).Trim();
                            logErr = "(" + sifraGreske + ") " + porukaGreske;

                            if (sifraGreske == "s013")
                            {
                                logErr += formatRestriktivneGreske(porukaGreske);
                            }
                        }
                    }
                    LogError(logErr);
                }
            }
            else
                odgovor = formatOdgovor("", "", zki, kontrolniBroj);
            return odgovor;
        }

        private string readFile()
        {
            string content = string.Empty;
            string error = string.Empty;
           
            System.Threading.Thread.Sleep(10);

            for(int i = 0; i < 3; i++)      // tri pokušaja čitanja filea
            {
                try
                {
                    using (FileStream fs = new FileStream(config.RequestFile, FileMode.Open, FileAccess.Read, FileShare.None))
                    {
                        using (StreamReader sr = new StreamReader(fs))
                        {
                            content = sr.ReadToEnd();
                            //sr.Close();
                        }
                        //fs.Close();
                    }
                    deleteFile(config.RequestFile);

                    // logiraj info da nije odprve prošlo
                    if (i > 0)
                    {
                        string info = "čitanje requesta uspjelo iz ponovnog pokušaja " + i;
                        if (!string.IsNullOrEmpty(error))
                            info = info + " (nakon " + error + ")";
                        LogInfo(info);
                    }
                    return content;
                }
                catch (Exception ex)
                {
                    error = ex.Message;
                }
                System.Threading.Thread.Sleep(500);
            }
            LogError(error);
            return string.Empty;  
        }

        private void deleteFile(string filename)
        {
            try { File.Delete(filename); }
            catch (Exception) { }
        }

        private void writeFile(string content)
        {
            string error = "Ne mogu pisati u " + config.ResponseFile;
          
            for(int i=0; i<2; i++)      // dva pokušaja pisanja u file
            {
                try
                {
                    System.IO.File.WriteAllText(config.ResponseFile, content);
                    return;
                }
                catch (Exception ex)
                {
                    error = "Ne mogu pisati u " + config.ResponseFile + "\n" + ex.Message;
                    System.Threading.Thread.Sleep(800);
                }
            }
            LogError(error);
        }
        
        private void worker_Completed(object sender, RunWorkerCompletedEventArgs e)
        {
            if (watcher != null)
            {
                watcher.EnableRaisingEvents = false;
                watcher.Dispose();
            }
            mutex.ReleaseMutex();

            worker.Dispose();
            worker = null;
        }

        private string formatOdgovor(string jir, string uuid, string zki, string kontrolniBroj)
        {
            return string.Format("{0,-36};{1,-36};{2,-32};{3,-20}", jir, uuid, zki, kontrolniBroj);
        }

        private string formatRestriktivneGreske(string poruka)
        {
            // https://porezna-uprava.gov.hr/UserDocsImages/Fiskalizacija/Tehni%C4%8Dke%20specifikacije/Fiskalizacija%20-%20Tehnicka%20specifikacija%20za%20korisnike_v2.6.pdf
            string ret = " ";
            if (poruka.Contains("176"))
            {
                ret += "Datum izdavanja računa je za više od 30 dana manji od trenutnog datuma. ";
            }
            if (poruka.Contains("177"))
            {
                ret += "Datum i vrijeme izdavanja računa je veće od trenutnog datuma. ";
            }
            if (poruka.Contains("178"))
            {
                ret += "Brojčana oznaka računa ima vrijednost '0'. ";
            }
            if (poruka.Contains("179"))
            {
                ret += "OIB operatera nije formalno ispravan. ";
            }
            if (poruka.Contains("180"))
            {
                ret += "OIB primatelja računa nije formalno ispravan. ";
            }
            if (poruka.Contains("181"))
            {
                ret += "OIB primatelja računa nije dozvoljen u kombinaciji s načinom plaćanja T(transakcijski račun). ";
            }
            if (poruka.Contains("182"))
            {
                ret += "Porezna stopa PDVa nije iz dozvoljenog skupa poreznih stopa. ";
            }
            if (poruka.Contains("183"))
            {
                ret += "Porezna stopa PNPa je manja od 0,00%. ";
            }
            if (poruka.Contains("184"))
            {
                ret += "Porezna stopa PNPa je veća od 3,00%. ";
            }
            return ret;
        }

        private string obradiRacunXml(string input)
        {
            string odgovor = formatOdgovor("", "", "", "");

            X509Certificate2 certifikat = CertificateStore();
            if (certifikat == null)
            {
                if (string.IsNullOrEmpty(config.CertificateSubject))
                    LogError("ne mogu čitati certifikat file " + config.CertificateFile);
                else
                    LogError("nepostojeći certifikat subject " + config.CertificateSubject);
                return odgovor;
            }

            // logiraj input u file
            DateTime dt = DateTime.Now;
            string logFilename = dt.ToString("HHmmssfff");
            string logErr = logFile.Write(dt, logFilename + "i", input);
            if (logErr != null) LogError(logErr);
            
            // pretvori input string u stream
            MemoryStream stream = new MemoryStream();
            StreamWriter writer = new StreamWriter(stream);
            writer.Write(input);
            writer.Flush();
            stream.Position = 0;

            // kreiraj XML dokument iz streama
            XmlDocument dokument = null;
            try
            {
                dokument = new XmlDocument();
                dokument.Load(stream);
            }
            catch (Exception ex)
            {
                LogError("XML loading: " + ex.Message);
            }
            finally
            {
                stream.Close();
                writer.Close();
            }

            if (dokument != null)
            {
                XmlDocument odgovorXml = null;

                try
                {
                    Raverus.FiskalizacijaDEV.CentralniInformacijskiSustav cis = new CentralniInformacijskiSustav();
                    cis.CisUrl = config.Url;
                    cis.TimeOut = (int)config.Timeout * 1000;
    
                    Raverus.FiskalizacijaDEV.PopratneFunkcije.Potpisivanje.PotpisiXmlDokument(dokument, certifikat);
                    Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DodajSoapEnvelope(ref dokument);
                    odgovorXml = cis.PosaljiSoapPoruku(dokument);
                }
                catch (Exception ex)
                {
                    LogError(String.Format("Greška kod obrade i slanja dokumenta: {0}", ex.Message));
                }
                
                if (odgovorXml != null)
                {
                    try
                    {
                        Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum tip = Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum.RacunOdgovor;
                        string uuid = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiUuid(odgovorXml, tip);
                        string jir = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiJir(odgovorXml);
                        odgovor = formatOdgovor(jir, uuid, "", "");
                        sysTrayForm.SetIcon(true);

                        // logiraj output u file
                        logErr = logFile.Write(dt, logFilename + "o", odgovorXml);
                        if (logErr != null) LogError(logErr);
                    }
                    catch (Exception ex)
                    {
                        LogError(String.Format("Greška kod dekodiranja jir i uuid: {0}", ex.Message));
                    }
                }
            }
            return odgovor;
        }

        // daj mi instalirani certifikat
        private X509Certificate2 CertificateStore()
        {
            X509Certificate2 certifikat = null;

            try
            {
                if (string.IsNullOrEmpty(config.CertificateSubject))
                    certifikat = Raverus.FiskalizacijaDEV.PopratneFunkcije.Potpisivanje.DohvatiCertifikat(config.CertificateFile, config.GetCertificatePass());
                else
                    certifikat = Raverus.FiskalizacijaDEV.PopratneFunkcije.Potpisivanje.DohvatiCertifikat(config.CertificateSubject);
            }
            catch (Exception ex)
            {
                LogError("Greška kod dohvata certifikata: " + ex.Message);
            }

            return certifikat;
        }

        private bool writeQR(RacunType racun, string jir, bool isQrBmp)
        {
            DateTime datumVrijemeIzdavanja = DateTime.ParseExact(racun.DatVrijeme, "dd.MM.yyyyTHH:mm:ss", System.Globalization.CultureInfo.InvariantCulture);
            string qrText;
            if (!String.IsNullOrWhiteSpace(jir))
            {
                qrText = String.Format("https://porezna.gov.hr/rn?jir={0}&datv={1:yyyyMMdd}_{2:HHmm}&izn={3}", jir, datumVrijemeIzdavanja, datumVrijemeIzdavanja, racun.IznosUkupno.Replace(".", "").Replace(",", ""));
            }
            else
            {
                qrText = String.Format("https://porezna.gov.hr/rn?zki={0}&datv={1:yyyyMMdd}_{2:HHmm}&izn={3}", racun.ZastKod, datumVrijemeIzdavanja, datumVrijemeIzdavanja, racun.IznosUkupno.Replace(".", "").Replace(",", ""));
            }

            QR qr = new QR(sysTrayForm);
            Configuration copy = config.Clone();
            if (isQrBmp)
            {
                copy.QRType = (int)QRItemType.BMP;
                copy.QRFile = Path.ChangeExtension(copy.QRFile, "BMP");
                //copy.QRFile = ".\\qR.BMP";
            }
            qr.WriteQR(qrText, copy, datumVrijemeIzdavanja, racun.BrRac.BrOznRac);
            return !qr.HasError();
        }

        private void CitajZadnjiRacunIzRegistry()
        {
            zadnjiRacDatum = new DateTime(2012, 1, 1);
            zadnjiRacBroj = 0;
            if (config.KontrolaRB != false)
            {
                RegistryKey rootKey = Registry.CurrentUser;
                using (RegistryKey registrySubKey = rootKey.OpenSubKey(REG_KEY))
                {
                    if (registrySubKey != null)
                    {
                        int godina = DateTime.Now.Year;
                        var regValue = registrySubKey.GetValue(ComposeRegistryKey(godina));
                        if (regValue != null)
                        {
                            try
                            {
                                string[] cells = regValue.ToString().Split(new char[] { ';' });
                                zadnjiRacDatum = new DateTime(Int32.Parse(cells[0]), Int32.Parse(cells[1]), Int32.Parse(cells[2]));
                                zadnjiRacBroj = Int32.Parse(cells[3]);
                            }
                            catch (Exception ex)
                            {
                                LogError(String.Format("Krivi datum/broj računa u registryju ({0}): {1}", regValue, ex.Message));
                            }
                        }
                    }
                }
            }
        }

        private void UpisiZadnjiRacunURegistry(DateTime datum, int brRacuna)
        {
            int godina = datum.Year;
            zadnjiRacDatum = new DateTime(godina, datum.Month, datum.Day);
            zadnjiRacBroj = brRacuna;
            RegistryKey rootKey = Registry.CurrentUser;
            using (RegistryKey registrySubKey = rootKey.CreateSubKey(REG_KEY))
            {
                registrySubKey.SetValue(ComposeRegistryKey(godina), String.Format("{0};{1};{2};{3}", godina, datum.Month, datum.Day, brRacuna));
            }
        }

        private string ComposeRegistryKey(int godina)
        {
            if ("P".Equals(config.OznakaSlijednosti))
                return String.Format("{0}_{1}_{2}", config.OIB, godina, config.OznakaPoslProstora);
            else
                return String.Format("{0}_{1}_{2}_{3}", config.OIB, godina, config.OznakaPoslProstora, config.OznakaNaplatnogUredjaja);
        }

        private void LogError(string message)
        {
            sysTrayForm.ShowBalloon(false, message);
            sysTrayForm.LogForm.Add(false, message);
        }
        private void LogInfo(string message)
        {
            //sysTrayForm.ShowBalloon(true, message);
            sysTrayForm.LogForm.Add(true, message);
        }
    }

}
