﻿using Raverus.FiskalizacijaDEV;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace Fiskalizacija.DOS.SysTray
{
    public partial class RadnoVrijemeForm : Form
    {
        private Configuration config;
        private SysTrayForm sysTrayForm;
        private readonly Stopwatch stopWatch;

        public RadnoVrijemeForm(SysTrayForm sysTrayForm, Configuration config)
        {
            InitializeComponent();
            this.Icon = new Icon(Properties.Resources.MainIcon, new Size(128, 128));
            this.config = config;
            this.sysTrayForm = sysTrayForm;
            stopWatch = new Stopwatch();

            LoadLocalConfig();
        }

        private void LoadLocalConfig()
        {
            try
            {
                string[] saved = File.ReadAllLines("radnovrijeme.config");
                if (saved.Length > 0) dtOd.Value = DateTime.ParseExact(saved[0], "yyyy-MM-dd", System.Globalization.CultureInfo.InvariantCulture);
                if (saved.Length > 1) tbPonOd1.Text = saved[1];
                if (saved.Length > 2) tbPonDo1.Text = saved[2];
                if (saved.Length > 3) tbUtoOd1.Text = saved[3];
                if (saved.Length > 4) tbUtoDo1.Text = saved[4];
                if (saved.Length > 5) tbSriOd1.Text = saved[5];
                if (saved.Length > 6) tbSriDo1.Text = saved[6];
                if (saved.Length > 7) tbCetOd1.Text = saved[7];
                if (saved.Length > 8) tbCetDo1.Text = saved[8];
                if (saved.Length > 9) tbPetOd1.Text = saved[9];
                if (saved.Length > 10) tbPetDo1.Text = saved[10];
                if (saved.Length > 11) tbSubOd1.Text = saved[11];
                if (saved.Length > 12) tbSubDo1.Text = saved[12];
                if (saved.Length > 13) tbNedOd1.Text = saved[13];
                if (saved.Length > 14) tbNedDo1.Text = saved[14];
                if (saved.Length > 15) rbJednokratno.Checked = bool.Parse(saved[15]);
                if (saved.Length > 16) rbDvokratno.Checked = bool.Parse(saved[16]);
                if (saved.Length > 17) rbPoDogovoru.Checked = bool.Parse(saved[17]);
                if (saved.Length > 18) tbPonOd2.Text = saved[18];
                if (saved.Length > 19) tbPonDo2.Text = saved[19];
                if (saved.Length > 20) tbUtoOd2.Text = saved[20];
                if (saved.Length > 21) tbUtoDo2.Text = saved[21];
                if (saved.Length > 22) tbSriOd2.Text = saved[22];
                if (saved.Length > 23) tbSriDo2.Text = saved[23];
                if (saved.Length > 24) tbCetOd2.Text = saved[24];
                if (saved.Length > 25) tbCetDo2.Text = saved[25];
                if (saved.Length > 26) tbPetOd2.Text = saved[26];
                if (saved.Length > 27) tbPetDo2.Text = saved[27];
                if (saved.Length > 28) tbSubOd2.Text = saved[28];
                if (saved.Length > 29) tbSubDo2.Text = saved[29];
                if (saved.Length > 30) tbNedOd2.Text = saved[30];
                if (saved.Length > 31) tbNedDo2.Text = saved[31];
                if (saved.Length > 32) tbPraOd1.Text = saved[32];
                if (saved.Length > 33) tbPraDo1.Text = saved[33];
                if (saved.Length > 34) tbPraOd2.Text = saved[34];
                if (saved.Length > 35) tbPraDo2.Text = saved[35];
            }
            catch (Exception)
            {
                dtOd.Value = DateTime.Now.AddDays(1);
                tbPonOd1.Text = "09:00";
                tbPonDo1.Text = "16:00";
                tbUtoOd1.Text = "09:00";
                tbUtoDo1.Text = "16:00";
                tbSriOd1.Text = "09:00";
                tbSriDo1.Text = "16:00";
                tbCetOd1.Text = "09:00";
                tbCetDo1.Text = "16:00";
                tbPetOd1.Text = "09:00";
                tbPetDo1.Text = "16:00";
            }
        }

        private void rbPoDogovoru_CheckedChanged(object sender, EventArgs e)
        {
            label1.Visible = false;
            label2.Visible = false;
            label3.Visible = false;
            label4.Visible = false;
            label5.Visible = false;
            label6.Visible = false;
            label7.Visible = false;
            label8.Visible = false;
            label9.Visible = false;
            label10.Visible = false;
            label11.Visible = false;
            label12.Visible = false;
            tbPonOd1.Visible = false;
            tbPonDo1.Visible = false;
            tbUtoOd1.Visible = false;
            tbUtoDo1.Visible = false;
            tbSriOd1.Visible = false;
            tbSriDo1.Visible = false;
            tbCetOd1.Visible = false;
            tbCetDo1.Visible = false;
            tbPetOd1.Visible = false;
            tbPetDo1.Visible = false;
            tbSubOd1.Visible = false;
            tbSubDo1.Visible = false;
            tbNedOd1.Visible = false;
            tbNedDo1.Visible = false;
            tbPraOd1.Visible = false;
            tbPraDo1.Visible = false;
            tbPonOd2.Visible = false;
            tbPonDo2.Visible = false;
            tbUtoOd2.Visible = false;
            tbUtoDo2.Visible = false;
            tbSriOd2.Visible = false;
            tbSriDo2.Visible = false;
            tbCetOd2.Visible = false;
            tbCetDo2.Visible = false;
            tbPetOd2.Visible = false;
            tbPetDo2.Visible = false;
            tbSubOd2.Visible = false;
            tbSubDo2.Visible = false;
            tbNedOd2.Visible = false;
            tbNedDo2.Visible = false;
            tbPraOd2.Visible = false;
            tbPraDo2.Visible = false;
        }

        private void rbJednokratno_CheckedChanged(object sender, EventArgs e)
        {
            label1.Visible = true;
            label2.Visible = true;
            label3.Visible = true;
            label4.Visible = true;
            label5.Visible = true;
            label6.Visible = true;
            label7.Visible = true;
            label8.Visible = true;
            label9.Visible = true;
            label10.Visible = false;
            label11.Visible = false;
            label12.Visible = true;
            tbPonOd1.Visible = true;
            tbPonDo1.Visible = true;
            tbUtoOd1.Visible = true;
            tbUtoDo1.Visible = true;
            tbSriOd1.Visible = true;
            tbSriDo1.Visible = true;
            tbCetOd1.Visible = true;
            tbCetDo1.Visible = true;
            tbPetOd1.Visible = true;
            tbPetDo1.Visible = true;
            tbSubOd1.Visible = true;
            tbSubDo1.Visible = true;
            tbNedOd1.Visible = true;
            tbNedDo1.Visible = true;
            tbPraOd1.Visible = true;
            tbPraDo1.Visible = true;
            tbPonOd2.Visible = false;
            tbPonDo2.Visible = false;
            tbUtoOd2.Visible = false;
            tbUtoDo2.Visible = false;
            tbSriOd2.Visible = false;
            tbSriDo2.Visible = false;
            tbCetOd2.Visible = false;
            tbCetDo2.Visible = false;
            tbPetOd2.Visible = false;
            tbPetDo2.Visible = false;
            tbSubOd2.Visible = false;
            tbSubDo2.Visible = false;
            tbNedOd2.Visible = false;
            tbNedDo2.Visible = false;
            tbPraOd2.Visible = false;
            tbPraDo2.Visible = false;
        }

        private void rbDvokratno_CheckedChanged(object sender, EventArgs e)
        {
            label1.Visible = true;
            label2.Visible = true;
            label3.Visible = true;
            label4.Visible = true;
            label5.Visible = true;
            label6.Visible = true;
            label7.Visible = true;
            label8.Visible = true;
            label9.Visible = true;
            label10.Visible = true;
            label11.Visible = true;
            label12.Visible = true;
            tbPonOd1.Visible = true;
            tbPonDo1.Visible = true;
            tbUtoOd1.Visible = true;
            tbUtoDo1.Visible = true;
            tbSriOd1.Visible = true;
            tbSriDo1.Visible = true;
            tbCetOd1.Visible = true;
            tbCetDo1.Visible = true;
            tbPetOd1.Visible = true;
            tbPetDo1.Visible = true;
            tbSubOd1.Visible = true;
            tbSubDo1.Visible = true;
            tbNedOd1.Visible = true;
            tbNedDo1.Visible = true;
            tbPraOd1.Visible = true;
            tbPraDo1.Visible = true;
            tbPonOd2.Visible = true;
            tbPonDo2.Visible = true;
            tbUtoOd2.Visible = true;
            tbUtoDo2.Visible = true;
            tbSriOd2.Visible = true;
            tbSriDo2.Visible = true;
            tbCetOd2.Visible = true;
            tbCetDo2.Visible = true;
            tbPetOd2.Visible = true;
            tbPetDo2.Visible = true;
            tbSubOd2.Visible = true;
            tbSubDo2.Visible = true;
            tbNedOd2.Visible = true;
            tbNedDo2.Visible = true;
            tbPraOd2.Visible = true;
            tbPraDo2.Visible = true;
        }

        private void btnOdustani_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btnPosalji_Click(object sender, EventArgs e)
        {
            // logiraj u file
            LogFile logFile = new LogFile();
            if (!logFile.Init(config.LogFolder))
                logFile = null;
            string logFileName = "radnoVrijeme" + DateTime.Now.ToString("HHmmss");

            btnPosalji.Enabled = false;
            Raverus.FiskalizacijaDEV.Schema.PoslovniProstorType poslProstor = new Raverus.FiskalizacijaDEV.Schema.PoslovniProstorType();
            poslProstor.Oib = config.OIB;
            poslProstor.OibOper = config.OIB;
            poslProstor.OznPosPr = config.OznakaPoslProstora;
            var radnoVrijemeType = new Raverus.FiskalizacijaDEV.Schema.RadnoVrijemeType();
            var redovno = new Raverus.FiskalizacijaDEV.Schema.RedovnoType();
            redovno.DatumOd = dtOd.Value.ToString("dd.MM.yyyy");
            radnoVrijemeType.Redovno.Add(redovno);
            if (rbJednokratno.Checked)
            {
                redovno.Items = new List<object>();
                if (!String.IsNullOrEmpty(tbPonOd1.Text) || !String.IsNullOrEmpty(tbPonDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item1;
                    jednokratnoType.RadnoVrijemeOd = tbPonOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbPonDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
                if (!String.IsNullOrEmpty(tbUtoOd1.Text) || !String.IsNullOrEmpty(tbUtoDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item2;
                    jednokratnoType.RadnoVrijemeOd = tbUtoOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbUtoDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
                if (!String.IsNullOrEmpty(tbSriOd1.Text) || !String.IsNullOrEmpty(tbSriDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item3;
                    jednokratnoType.RadnoVrijemeOd = tbSriOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbSriDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
                if (!String.IsNullOrEmpty(tbCetOd1.Text) || !String.IsNullOrEmpty(tbCetDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item4;
                    jednokratnoType.RadnoVrijemeOd = tbCetOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbCetDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
                if (!String.IsNullOrEmpty(tbPetOd1.Text) || !String.IsNullOrEmpty(tbPetDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item5;
                    jednokratnoType.RadnoVrijemeOd = tbPetOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbPetDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
                if (!String.IsNullOrEmpty(tbSubOd1.Text) || !String.IsNullOrEmpty(tbSubDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item6;
                    jednokratnoType.RadnoVrijemeOd = tbSubOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbSubDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
                if (!String.IsNullOrEmpty(tbNedOd1.Text) || !String.IsNullOrEmpty(tbNedDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item7;
                    jednokratnoType.RadnoVrijemeOd = tbNedOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbNedDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
                if (!String.IsNullOrEmpty(tbPraOd1.Text) || !String.IsNullOrEmpty(tbPraDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.JednokratnoType jednokratnoType = new Raverus.FiskalizacijaDEV.Schema.JednokratnoType();
                    jednokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item8;
                    jednokratnoType.RadnoVrijemeOd = tbPraOd1.Text;
                    jednokratnoType.RadnoVrijemeDo = tbPraDo1.Text;
                    redovno.Items.Add(jednokratnoType);
                }
            }
            else if (rbDvokratno.Checked)
            {
                redovno.Items = new List<object>();
                if (!String.IsNullOrEmpty(tbPonOd1.Text) || !String.IsNullOrEmpty(tbPonDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item1;
                    dvokratnoType.RadnoVrijemeOd = tbPonOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbPonDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbUtoOd1.Text) || !String.IsNullOrEmpty(tbUtoDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item2;
                    dvokratnoType.RadnoVrijemeOd = tbUtoOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbUtoDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbSriOd1.Text) || !String.IsNullOrEmpty(tbSriDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item3;
                    dvokratnoType.RadnoVrijemeOd = tbSriOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbSriDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbCetOd1.Text) || !String.IsNullOrEmpty(tbCetDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item4;
                    dvokratnoType.RadnoVrijemeOd = tbCetOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbCetDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbPetOd1.Text) || !String.IsNullOrEmpty(tbPetDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item5;
                    dvokratnoType.RadnoVrijemeOd = tbPetOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbPetDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbSubOd1.Text) || !String.IsNullOrEmpty(tbSubDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item6;
                    dvokratnoType.RadnoVrijemeOd = tbSubOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbSubDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbNedOd1.Text) || !String.IsNullOrEmpty(tbNedDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item7;
                    dvokratnoType.RadnoVrijemeOd = tbNedOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbNedDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbPraOd1.Text) || !String.IsNullOrEmpty(tbPraDo1.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item8;
                    dvokratnoType.RadnoVrijemeOd = tbPraOd1.Text;
                    dvokratnoType.RadnoVrijemeDo = tbPraDo1.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item1;
                    redovno.Items.Add(dvokratnoType);
                }


                if (!String.IsNullOrEmpty(tbPonOd2.Text) || !String.IsNullOrEmpty(tbPonDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item1;
                    dvokratnoType.RadnoVrijemeOd = tbPonOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbPonDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbUtoOd2.Text) || !String.IsNullOrEmpty(tbUtoDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item2;
                    dvokratnoType.RadnoVrijemeOd = tbUtoOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbUtoDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbSriOd2.Text) || !String.IsNullOrEmpty(tbSriDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item3;
                    dvokratnoType.RadnoVrijemeOd = tbSriOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbSriDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbCetOd2.Text) || !String.IsNullOrEmpty(tbCetDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item4;
                    dvokratnoType.RadnoVrijemeOd = tbCetOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbCetDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbPetOd2.Text) || !String.IsNullOrEmpty(tbPetDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item5;
                    dvokratnoType.RadnoVrijemeOd = tbPetOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbPetDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbSubOd2.Text) || !String.IsNullOrEmpty(tbSubDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item6;
                    dvokratnoType.RadnoVrijemeOd = tbSubOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbSubDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbNedOd2.Text) || !String.IsNullOrEmpty(tbNedDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item7;
                    dvokratnoType.RadnoVrijemeOd = tbNedOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbNedDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
                if (!String.IsNullOrEmpty(tbPraOd2.Text) || !String.IsNullOrEmpty(tbPraDo2.Text))
                {
                    Raverus.FiskalizacijaDEV.Schema.DvokratnoType dvokratnoType = new Raverus.FiskalizacijaDEV.Schema.DvokratnoType();
                    dvokratnoType.DanUTjednu = Raverus.FiskalizacijaDEV.Schema.DanUTjednuType.Item8;
                    dvokratnoType.RadnoVrijemeOd = tbPraOd2.Text;
                    dvokratnoType.RadnoVrijemeDo = tbPraDo2.Text;
                    dvokratnoType.DioDvokratnog = Raverus.FiskalizacijaDEV.Schema.DioDvokratnogType.Item2;
                    redovno.Items.Add(dvokratnoType);
                }
            }
            else if (rbPoDogovoru.Checked)
            {
                Raverus.FiskalizacijaDEV.Schema.PoDogovoruType poDogovoruType = new Raverus.FiskalizacijaDEV.Schema.PoDogovoruType();
                redovno.Items = new List<object>(){ poDogovoruType };
            }

            poslProstor.Item = radnoVrijemeType;

            Raverus.FiskalizacijaDEV.CentralniInformacijskiSustav cis = new CentralniInformacijskiSustav();
            cis.CisUrl = config.Url;
            cis.TimeOut = (int)config.Timeout * 1000;
            cis.SoapMessageSending += cis_SoapMessageSending;
            cis.SoapMessageSent += cis_SoapMessageSent;
            Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum tipOdgovora = Raverus.FiskalizacijaDEV.PopratneFunkcije.TipDokumentaEnum.PrijaviRadnoVrijemeOdgovor;

            if (logFile != null)
                logFile.Write(DateTime.Now, logFileName + "i", poslProstor);

            try
            {
                XmlDocument doc;

                if (string.IsNullOrEmpty(config.CertificateSubject))
                    doc = cis.PosaljiRadnoVrijeme(poslProstor, Raverus.FiskalizacijaDEV.PopratneFunkcije.Potpisivanje.DohvatiCertifikat(config.CertificateFile, config.GetCertificatePass()));
                else
                    doc = cis.PosaljiRadnoVrijeme(poslProstor, config.CertificateSubject);

                if (doc != null)
                {
                    if (logFile != null)
                        logFile.Write(DateTime.Now, logFileName + "o", doc);

                    string sifraGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiSifruGreske(doc, tipOdgovora);
                    if (!string.IsNullOrEmpty(sifraGreske))
                    {
                        string porukaGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiPorukuGreske(doc, tipOdgovora).Trim();
                        MessageBox.Show(this, "Greška "+ sifraGreske+"\n"+ porukaGreske, "Prijava radnog vremena", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        sysTrayForm.LogForm.Add(false, porukaGreske);
                    }
                    else
                        MessageBox.Show(this, "Poslano dobro"/*doc.InnerXml*/, "OK", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else
                {
                    stopWatch.Stop();
                    MessageBox.Show(this, "GREŠKA SLANJA", "ops", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    btnPosalji.Enabled = true;
                }
            }
            catch (Exception ex)
            {
                stopWatch.Stop();
                if (cis.OdgovorGreska != null)
                {
                    string sifraGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiSifruGreske(cis.OdgovorGreska, tipOdgovora);
                    if (!string.IsNullOrEmpty(sifraGreske))
                    {
                        string porukaGreske = Raverus.FiskalizacijaDEV.PopratneFunkcije.XmlDokumenti.DohvatiPorukuGreske(cis.OdgovorGreska, tipOdgovora).Trim();
                        MessageBox.Show(this, "Greška " + sifraGreske + "\n" + porukaGreske, "Prijava radnog vremena", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        sysTrayForm.LogForm.Add(false, porukaGreske);
                    }
                    else
                        MessageBox.Show(this, ex.Message + "\n" + ex.StackTrace, "greška", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                    MessageBox.Show(this, ex.Message + "\n" + ex.StackTrace, "greška", MessageBoxButtons.OK, MessageBoxIcon.Error);

                btnPosalji.Enabled = true;
            }


            try
            {
                StringBuilder sb = new StringBuilder();
                sb.Append(dtOd.Value.ToString("yyyy-MM-dd"));
                sb.Append("\r\n");
                sb.Append(tbPonOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbPonDo1.Text);
                sb.Append("\r\n");
                sb.Append(tbUtoOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbUtoDo1.Text);
                sb.Append("\r\n");
                sb.Append(tbSriOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbSriDo1.Text);
                sb.Append("\r\n");
                sb.Append(tbCetOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbCetDo1.Text);
                sb.Append("\r\n");
                sb.Append(tbPetOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbPetDo1.Text);
                sb.Append("\r\n");
                sb.Append(tbSubOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbSubDo1.Text);
                sb.Append("\r\n");
                sb.Append(tbNedOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbNedDo1.Text);
                sb.Append("\r\n");
                sb.Append(rbJednokratno.Checked);
                sb.Append("\r\n");
                sb.Append(rbDvokratno.Checked);
                sb.Append("\r\n");
                sb.Append(rbPoDogovoru.Checked);
                sb.Append("\r\n");
                sb.Append(tbPonOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbPonDo2.Text);
                sb.Append("\r\n");
                sb.Append(tbUtoOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbUtoDo2.Text);
                sb.Append("\r\n");
                sb.Append(tbSriOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbSriDo2.Text);
                sb.Append("\r\n");
                sb.Append(tbCetOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbCetDo2.Text);
                sb.Append("\r\n");
                sb.Append(tbPetOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbPetDo2.Text);
                sb.Append("\r\n");
                sb.Append(tbSubOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbSubDo2.Text);
                sb.Append("\r\n");
                sb.Append(tbNedOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbNedDo2.Text);
                sb.Append("\r\n");
                sb.Append(tbPraOd1.Text);
                sb.Append("\r\n");
                sb.Append(tbPraDo1.Text);
                sb.Append("\r\n");
                sb.Append(tbPraOd2.Text);
                sb.Append("\r\n");
                sb.Append(tbPraDo2.Text);
                sb.Append("\r\n");
                File.WriteAllText("radnovrijeme.config", sb.ToString());
            }
            catch (Exception)
            { }
        }

        void cis_SoapMessageSending(object sender, CentralniInformacijskiSustavEventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            stopWatch.Start();
            Application.DoEvents();
        }

        void cis_SoapMessageSent(object sender, EventArgs e)
        {
            stopWatch.Stop();
            btnPosalji.Enabled = true;
            lblVrijeme.Text = String.Format("Vrijeme: {0} s", stopWatch.Elapsed.TotalSeconds);
            Application.DoEvents();
            stopWatch.Reset();
            Cursor.Current = Cursors.Default;
        }

    }
}
