﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;

namespace Fiskalizacija.DOS.SysTray
{
    static class TocnoVrijeme
    {
        public static void Get(string urlDatum, out string datum, out string error)
        {
            datum = null;
            error = null;
            if (string.IsNullOrEmpty(urlDatum))
                urlDatum = "http://www.google.hr";        // default url za točno vrijeme ako nije postavljen

            try
            {
                ServicePointManager.Expect100Continue = true;       // ignoriraj provjeru ssl certifikata za request točnog vremena
                ServicePointManager.DefaultConnectionLimit = 9999;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls12 | SecurityProtocolType.Ssl3;

                WebRequest webRequest = HttpWebRequest.Create(urlDatum);
                webRequest.Method = "HEAD";
                using (WebResponse webResponse = webRequest.GetResponse())
                {
                    string dateString = webResponse.Headers["Date"];    // u formatu: "Tue, 28 Jul 2015 21:12:01 GMT"
                    if (string.IsNullOrEmpty(dateString))
                        error = "ne postoji datum/vrijeme u headeru od " + urlDatum;
                    else
                    {
                        DateTime dt = Convert.ToDateTime(dateString);
                        datum = string.Format("{0:yyyyMMdd}\r\n{1:HH:mm:ss}", dt, dt);
                    }
                }

                // stara implementacija prije nego je server earthtools.org prdnuo u čabar
                /*using (var client = new WebClient())
                {
                    string result = client.DownloadString("http://www.earthtools.org/timezone-1.1/45/14");
                    int pos = result.IndexOf("<isotime>");
                    if (pos > 0)
                    {
                        string godina = result.Substring(pos + 9, 4);
                        string mjesec = result.Substring(pos + 14, 2);
                        string dan = result.Substring(pos + 17, 2);
                        string vrijeme = result.Substring(pos + 20, 8);
                        datum = godina + mjesec + dan + "\r\n" + vrijeme;
                    }
                    else
                        error = "krivi sadržaj točnog datuma: " + result;
                }*/
            }
            catch (Exception ex)
            {
                error = "greška čitanja točnog datuma sa " + urlDatum + "\n" + ex.Message;
            }
        }
    }

    /*
        Ovaj XML kako je prikazan dolje vraća poziv sa http://www.earthtools.org/timezone-1.1/45/14
        Treba izvući isotime.
        <timezone xsi:noNamespaceSchemaLocation="http://www.earthtools.org/timezone.xsd">
            <version>1.0</version>
            <location>
                <latitude>45</latitude>
                <longitude>14</longitude>
            </location>
            <offset>1</offset>
            <suffix>A</suffix>
            <localtime>24 Nov 2012 21:32:48</localtime>
            <isotime>2012-11-24 21:32:48 +0100</isotime>
            <utctime>2012-11-24 20:32:48</utctime>
            <dst>False</dst>
        </timezone>
     */
}
